/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.qti;

import java.util.HashMap;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.TensorFlowLite;

public class QnnDelegate
implements Delegate,
AutoCloseable {
    private static final long DELEGATE_HANDLE_INVALID = 0L;
    private static final String QNN_DELEGATE_JNI = "qnn_delegate_jni";
    private long delegateHandle = 0L;
    private boolean isPlatformSupported = true;
    private static volatile boolean jniLibraryLoaded = false;

    public QnnDelegate(Options options) throws UnsupportedOperationException {
        QnnDelegate.ensureJNILibraryLoaded();
        TensorFlowLite.init();
        this.delegateHandle = QnnDelegate.createDelegate(options);
        if (this.delegateHandle == 0L) {
            throw new UnsupportedOperationException("ERROR: Creation of QnnDelegate failed, return DELEGATE_HANDLE_INVALID.");
        }
        Capability cap = QnnDelegate.optionsToCapability(options);
        this.isPlatformSupported = QnnDelegate.hasCapability(cap.getValue(), Capability.INVALID.getValue());
    }

    public long getNativeHandle() {
        return this.delegateHandle;
    }

    @Override
    public void close() {
        if (this.delegateHandle != 0L) {
            QnnDelegate.deleteDelegate(this.delegateHandle);
            this.delegateHandle = 0L;
        }
    }

    public boolean isAvailable() {
        return this.isPlatformSupported;
    }

    public static int[] getVersion() {
        int major = QnnDelegate.getApiVersionMajor();
        int minor = QnnDelegate.getApiVersionMinor();
        int patch = QnnDelegate.getApiVersionPatch();
        int[] version = new int[]{major, minor, patch};
        return version;
    }

    public void performanceVote() {
        if (this.delegateHandle == 0L) {
            return;
        }
        QnnDelegate.setPerf(this.delegateHandle, PerformanceAction.PerformanceVote.getValue());
    }

    public void performanceRelease() {
        if (this.delegateHandle == 0L) {
            return;
        }
        QnnDelegate.setPerf(this.delegateHandle, PerformanceAction.PerformanceRelease.getValue());
    }

    private static Capability optionsToCapability(Options options) {
        Capability cap = Capability.INVALID;
        if (options.backendType == Options.BackendType.HTP_BACKEND) {
            if (options.htpPrecision == Options.HtpPrecision.HTP_PRECISION_QUANTIZED) {
                cap = Capability.HTP_RUNTIME_QUANTIZED;
            } else if (options.htpPrecision == Options.HtpPrecision.HTP_PRECISION_FP16) {
                cap = Capability.HTP_RUNTIME_FP16;
            }
        } else if (options.backendType == Options.BackendType.GPU_BACKEND) {
            cap = Capability.GPU_RUNTIME;
        } else if (options.backendType == Options.BackendType.DSP_BACKEND) {
            cap = Capability.DSP_RUNTIME;
        }
        return cap;
    }

    private static void ensureJNILibraryLoaded() {
        if (jniLibraryLoaded) {
            return;
        }
        try {
            System.loadLibrary(QNN_DELEGATE_JNI);
            jniLibraryLoaded = true;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to load QNN Delegate JNI library: " + e);
        }
    }

    public void enableHtpQuickResponse() {
        this.enableHtpHeartbeat(this.delegateHandle);
    }

    private static native long createDelegate(Options var0);

    public static boolean checkCapability(Capability cap) {
        QnnDelegate.ensureJNILibraryLoaded();
        return QnnDelegate.QnnDelegateHasCapability(cap.getValue());
    }

    private static native void deleteDelegate(long var0);

    private static native void setPerf(long var0, int var2);

    private static native boolean hasCapability(int var0, int var1);

    private static native int getApiVersionMajor();

    private static native int getApiVersionMinor();

    private static native int getApiVersionPatch();

    public static native boolean QnnDelegateHasCapability(int var0);

    private native void enableHtpHeartbeat(long var1);

    public static enum Capability {
        HTP_RUNTIME_QUANTIZED(0),
        HTP_RUNTIME_FP16(1),
        GPU_RUNTIME(2),
        DSP_RUNTIME(3),
        INVALID(99);

        private final int value;

        private Capability(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static enum PerformanceAction {
        PerformanceVote(0),
        PerformanceRelease(1);

        private final int value;

        private PerformanceAction(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static final class Options {
        private BackendType backendType = BackendType.UNDEFINED_BACKEND;
        private String libraryPath = null;
        private String skelLibraryDir = null;
        private GpuPrecision gpuPrecision = GpuPrecision.GPU_PRECISION_USER_PROVIDED;
        private GpuPerformanceMode gpuPerformanceMode = GpuPerformanceMode.GPU_PERFORMANCE_HIGH;
        private HtpPerformanceMode htpPerformanceMode = HtpPerformanceMode.HTP_PERFORMANCE_DEFAULT;
        private HtpPrecision htpPrecision = HtpPrecision.HTP_PRECISION_QUANTIZED;
        private HtpPdSession htpPdSession = HtpPdSession.HTP_PD_SESSION_UNSIGNED;
        private HtpOptimizationStrategy htpOptimizationStrategy = HtpOptimizationStrategy.HTP_OPTIMIZE_FOR_INFERENCE;
        private HtpPerfCtrlStrategy htpPerfCtrlStrategy = HtpPerfCtrlStrategy.HTP_PERF_CTRL_MANUAL;
        private HtpUseConvHmx htpUseConvHmx = HtpUseConvHmx.HTP_CONV_HMX_ON;
        private HtpUseFoldRelu htpUseFoldRelu = HtpUseFoldRelu.HTP_FOLD_RELU_OFF;
        private DspPerformanceMode dspPerformanceMode = DspPerformanceMode.DSP_PERFORMANCE_DEFAULT;
        private DspPdSession dspPdSession = DspPdSession.DSP_PD_SESSION_UNSIGNED;
        private DspPerfCtrlStrategy dspPerfCtrlStrategy = DspPerfCtrlStrategy.DSP_PERF_CTRL_MANUAL;
        private LogLevel logLevel = LogLevel.LOG_OFF;
        private ProfilingOptions profiling = ProfilingOptions.PROFILING_OFF;
        private OpPackageInfo[] opPackageInfos = null;
        private String cacheDir = null;
        private String modelToken = null;
        private int[] skipNodeIds = null;
        private int[] skipOps = null;

        public int getBackendType() {
            return this.backendType.getValue();
        }

        public String getLibraryPath() {
            return this.libraryPath;
        }

        public String getSkelLibraryDir() {
            return this.skelLibraryDir;
        }

        public int getGpuPrecision() {
            return this.gpuPrecision.getValue();
        }

        public int getGpuPerformanceMode() {
            return this.gpuPerformanceMode.getValue();
        }

        public int getHtpPerformanceMode() {
            return this.htpPerformanceMode.getValue();
        }

        public int getHtpPrecision() {
            return this.htpPrecision.getValue();
        }

        public int getHtpUseConvHmx() {
            return this.htpUseConvHmx.getValue();
        }

        public int getHtpUseFoldRelu() {
            return this.htpUseFoldRelu.getValue();
        }

        public int getHtpPdSession() {
            return this.htpPdSession.getValue();
        }

        public int getHtpOptimizationStrategy() {
            return this.htpOptimizationStrategy.getValue();
        }

        public int getHtpPerfCtrlStrategy() {
            return this.htpPerfCtrlStrategy.getValue();
        }

        public int getDspPerformanceMode() {
            return this.dspPerfCtrlStrategy.getValue();
        }

        public int getDspPdSession() {
            return this.dspPdSession.getValue();
        }

        public int getDspPerfCtrlStrategy() {
            return this.dspPerfCtrlStrategy.getValue();
        }

        public int getLogLevel() {
            return this.logLevel.getValue();
        }

        public int getProfiling() {
            return this.profiling.getValue();
        }

        public String getCacheDir() {
            return this.cacheDir;
        }

        public String getModelToken() {
            return this.modelToken;
        }

        public int getOpPackageInfosLength() {
            return this.opPackageInfos == null ? 0 : this.opPackageInfos.length;
        }

        public OpPackageInfo[] getOpPackageInfos() {
            return this.opPackageInfos;
        }

        public int[] getSkipNodeIds() {
            return this.skipNodeIds;
        }

        public int[] getSkipOps() {
            return this.skipOps;
        }

        public void setBackendType(BackendType input) {
            this.backendType = input;
        }

        public void setLibraryPath(String input) {
            this.libraryPath = input;
        }

        public void setSkelLibraryDir(String input) {
            this.skelLibraryDir = input;
        }

        public void setGpuOptions(GpuPerformanceMode mode, GpuPrecision precision) {
            this.gpuPerformanceMode = mode;
            this.gpuPrecision = precision;
        }

        public void setGpuPerformanceMode(GpuPerformanceMode mode) {
            this.gpuPerformanceMode = mode;
        }

        public void setGpuPrecision(GpuPrecision precision) {
            this.gpuPrecision = precision;
        }

        public void setHtpOptions(HtpPerformanceMode mode, HtpPrecision precision, HtpPdSession pdSession, HtpOptimizationStrategy optimizationStrategy) {
            this.htpPerformanceMode = mode;
            this.htpPrecision = precision;
            this.htpPdSession = pdSession;
            this.htpOptimizationStrategy = optimizationStrategy;
        }

        public void setHtpPerformanceMode(HtpPerformanceMode mode) {
            this.htpPerformanceMode = mode;
        }

        public void setHtpPrecision(HtpPrecision precision) {
            this.htpPrecision = precision;
        }

        public void setHtpUseConvHmx(HtpUseConvHmx useConvHmx) {
            this.htpUseConvHmx = useConvHmx;
        }

        public void setHtpUseFoldRelu(HtpUseFoldRelu useFoldRelu) {
            this.htpUseFoldRelu = useFoldRelu;
        }

        public void setHtpPdSession(HtpPdSession pdSession) {
            this.htpPdSession = pdSession;
        }

        public void setHtpOptimizationStrategy(HtpOptimizationStrategy optimizationStrategy) {
            this.htpOptimizationStrategy = optimizationStrategy;
        }

        public void setHtpPerfCtrlStrategy(HtpPerfCtrlStrategy perfCtrl) {
            this.htpPerfCtrlStrategy = perfCtrl;
        }

        public void setDspOptions(DspPerformanceMode mode, DspPdSession pdSession) {
            this.dspPerformanceMode = mode;
            this.dspPdSession = pdSession;
        }

        public void setDspPerformanceMode(DspPerformanceMode mode) {
            this.dspPerformanceMode = mode;
        }

        public void setDspPdSession(DspPdSession pdSession) {
            this.dspPdSession = pdSession;
        }

        public void setDspPerfCtrlStrategy(DspPerfCtrlStrategy perfCtrl) {
            this.dspPerfCtrlStrategy = perfCtrl;
        }

        public void setLogLevel(LogLevel input) {
            this.logLevel = input;
        }

        public void setProfiling(ProfilingOptions input) {
            this.profiling = input;
        }

        public void setOpPackageOptions(OpPackageInfo[] info) {
            int numOpPackageOptions = info.length;
            this.opPackageInfos = new OpPackageInfo[numOpPackageOptions];
            for (int i = 0; i < numOpPackageOptions; ++i) {
                this.opPackageInfos[i] = new OpPackageInfo(info[i].getOpPackageName(), info[i].getOpPackagePath(), info[i].getInterfaceProvider(), info[i].getOpPackageTarget(), info[i].getOpsMap());
            }
        }

        public void setCacheDir(String input) {
            this.cacheDir = input;
        }

        public void setModelToken(String input) {
            this.modelToken = input;
        }

        public void setSkipNodeIds(int[] ids) {
            if (ids == null) {
                return;
            }
            int numSkipNodeIds = ids.length;
            this.skipNodeIds = new int[numSkipNodeIds];
            for (int i = 0; i < numSkipNodeIds; ++i) {
                this.skipNodeIds[i] = ids[i];
            }
        }

        public void setSkipOps(int[] ops) {
            if (ops == null) {
                return;
            }
            int numSkipOps = ops.length;
            this.skipOps = new int[numSkipOps];
            for (int i = 0; i < numSkipOps; ++i) {
                this.skipOps[i] = ops[i];
            }
        }

        public static final class OpPackageInfo {
            private String opPackageName;
            private String opPackagePath;
            private String interfaceProvider;
            private String opPackageTarget;
            private HashMap<String, String> opPackageOpsMap = null;

            public OpPackageInfo(String name, String path, String provider, String target, HashMap<String, String> opsMap) {
                this.opPackageName = name;
                this.opPackagePath = path;
                this.interfaceProvider = provider;
                this.opPackageTarget = target;
                this.opPackageOpsMap = new HashMap<String, String>(opsMap);
            }

            public String getOpPackageName() {
                return this.opPackageName;
            }

            public String getOpPackagePath() {
                return this.opPackagePath;
            }

            public String getInterfaceProvider() {
                return this.interfaceProvider;
            }

            public String getOpPackageTarget() {
                return this.opPackageTarget;
            }

            public HashMap<String, String> getOpsMap() {
                return this.opPackageOpsMap;
            }
        }

        public static enum HtpOptimizationStrategy {
            HTP_OPTIMIZE_FOR_INFERENCE(0),
            HTP_OPTIMIZE_FOR_PREPARE(1);

            private final int value;

            private HtpOptimizationStrategy(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum HtpUseFoldRelu {
            HTP_FOLD_RELU_OFF(0),
            HTP_FOLD_RELU_ON(1);

            private final int value;

            private HtpUseFoldRelu(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum HtpUseConvHmx {
            HTP_CONV_HMX_OFF(0),
            HTP_CONV_HMX_ON(1);

            private final int value;

            private HtpUseConvHmx(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum HtpPrecision {
            HTP_PRECISION_QUANTIZED(0),
            HTP_PRECISION_FP16(1);

            private final int value;

            private HtpPrecision(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum DspPdSession {
            DSP_PD_SESSION_UNSIGNED(0),
            DSP_PD_SESSION_SIGNED(1),
            DSP_PD_SESSION_ADAPTIVE(2);

            private final int value;

            private DspPdSession(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum HtpPdSession {
            HTP_PD_SESSION_UNSIGNED(0),
            HTP_PD_SESSION_SIGNED(1);

            private final int value;

            private HtpPdSession(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum DspPerfCtrlStrategy {
            DSP_PERF_CTRL_MANUAL(0),
            DSP_PERF_CTRL_AUTO(1);

            private final int value;

            private DspPerfCtrlStrategy(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum HtpPerfCtrlStrategy {
            HTP_PERF_CTRL_MANUAL(0),
            HTP_PERF_CTRL_AUTO(1);

            private final int value;

            private HtpPerfCtrlStrategy(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum DspPerformanceMode {
            DSP_PERFORMANCE_DEFAULT(0),
            DSP_PERFORMANCE_SUSTAINED_HIGH_PERFORMANCE(1),
            DSP_PERFORMANCE_BURST(2),
            DSP_PERFORMANCE_HIGH_PERFORMANCE(3),
            DSP_PERFORMANCE_POWER_SAVER(4),
            DSP_PERFORMANCE_LOW_POWER_SAVER(5),
            DSP_PERFORMANCE_HIGH_POWER_SAVER(6),
            DSP_PERFORMANCE_LOW_BALANCE(7),
            DSP_PERFORMANCE_BALANCE(8);

            private final int value;

            private DspPerformanceMode(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum HtpPerformanceMode {
            HTP_PERFORMANCE_DEFAULT(0),
            HTP_PERFORMANCE_SUSTAINED_HIGH_PERFORMANCE(1),
            HTP_PERFORMANCE_BURST(2),
            HTP_PERFORMANCE_HIGH_PERFORMANCE(3),
            HTP_PERFORMANCE_POWER_SAVER(4),
            HTP_PERFORMANCE_LOW_POWER_SAVER(5),
            HTP_PERFORMANCE_HIGH_POWER_SAVER(6),
            HTP_PERFORMANCE_LOW_BALANCE(7),
            HTP_PERFORMANCE_BALANCE(8);

            private final int value;

            private HtpPerformanceMode(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum GpuPerformanceMode {
            GPU_PERFORMANCE_DEFAULT(0),
            GPU_PERFORMANCE_HIGH(1),
            GPU_PERFORMANCE_NORMAL(2),
            GPU_PERFORMANCE_LOW(3);

            private final int value;

            private GpuPerformanceMode(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum GpuPrecision {
            GPU_PRECISION_USER_PROVIDED(0),
            GPU_PRECISION_FP32(1),
            GPU_PRECISION_FP16(2),
            GPU_PRECISION_HYBRID(3);

            private final int value;

            private GpuPrecision(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum ProfilingOptions {
            PROFILING_OFF(0),
            PER_OP_PROFILING(1),
            PLATFORM_TRACING_PROFILING(2);

            private final int value;

            private ProfilingOptions(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum LogLevel {
            LOG_OFF(0),
            LOG_LEVEL_ERROR(1),
            LOG_LEVEL_WARN(2),
            LOG_LEVEL_INFO(3),
            LOG_LEVEL_VERBOSE(4),
            LOG_LEVEL_DEBUG(5);

            private final int value;

            private LogLevel(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum BackendType {
            UNDEFINED_BACKEND(0),
            GPU_BACKEND(1),
            HTP_BACKEND(2),
            DSP_BACKEND(3);

            private final int value;

            private BackendType(int newValue) {
                this.value = newValue;
            }

            public int getValue() {
                return this.value;
            }
        }
    }
}

