/*
 * Copyright (c) 2013-2017 QuartzDesk.com. All Rights Reserved.
 * QuartzDesk.com PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.quartzdesk.api;

import java.util.TimeZone;

/**
 * Various commonly used constants throughout the API.
 */
public interface ApiConst
{
  /**
   * UTF-8 encoding.
   */
  String ENCODING_UTF8 = "UTF-8";

  /**
   * ISO-8859-1 (Latin1) encoding.
   */
  String ENCODING_ISO_8859_1 = "ISO-8859-1";

  /**
   * UTC time-zone.
   */
  TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone( "UTC" );

  /**
   * Platform dependent new line separator.
   */
  String NL = System.getProperty( "line.separator" );
}
