/*
 * Copyright (c) 2013-2017 QuartzDesk.com. All Rights Reserved.
 * QuartzDesk.com PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.quartzdesk.api.common.security;

import com.quartzdesk.api.common.encoding.BASE64Decoder;
import com.quartzdesk.api.common.encoding.BASE64Encoder;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;

/**
 * @author Jan Moravec
 * @version $Id:$
 */
public class SecurityUtils
{
  /**
   * Converts the specified key into the BASE64 format.
   *
   * @param key a key.
   * @return the BASE64 key representation.
   */
  public static String symmetricKeyToBASE64( Key key )
  {
    byte[] keyBytes = key.getEncoded();
    return BASE64Encoder.encode( keyBytes );
  }


  /**
   * Converts the specified secret key represented as a BASE64 string into a secret key.
   *
   * @param base64 a BASE64 encoded secret key.
   * @param keyAlg the key algorithm.
   * @return the secret key.
   * @throws SecurityException if the specified string is not BASE64 encoded.
   */
  public static SecretKey symmetricKeyFromBASE64( String base64, String keyAlg )
  {
    byte[] keyBytes = BASE64Decoder.decode( base64 );
    return new SecretKeySpec( keyBytes, keyAlg );
  }
}
