/*
 * Copyright (c) 2013-2017 QuartzDesk.com. All Rights Reserved.
 * QuartzDesk.com PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.quartzdesk.api.web.security;

import java.util.Date;

/**
 * @author Jan Moravec
 * @version $Id:$
 */
public class SecurityToken
{
  private String principalName;
  private Date validTo;

  public SecurityToken( String principalName, Date validTo )
  {
    this.principalName = principalName;
    this.validTo = validTo;
  }

  public String getPrincipalName()
  {
    return principalName;
  }

  public Date getValidTo()
  {
    return validTo;
  }

  @Override
  public String toString()
  {
    return new StringBuilder( SecurityToken.class.getSimpleName() )
        .append( '[' )
        .append( "principalName=" ).append( principalName )
        .append( ", validTo=" ).append( validTo )
        .append( ']' ).toString();

  }
}
