/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api;

import com.quartzdesk.api.ApiConst;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public final class ApiDebug {
    private ApiDebug() {
    }

    public static String getClassInfo(Class<?> clazz) {
        Class<?>[] ifaces;
        StringBuilder sb = new StringBuilder();
        ClassLoader cl = clazz.getClassLoader();
        sb.append(clazz.getName());
        CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
        sb.append(", code source: ").append(clazzCS);
        sb.append(ApiConst.NL).append("class loader:").append(ApiConst.NL);
        sb.append(ApiDebug.getClassLoaderInfo(cl));
        sb.append(ApiConst.NL).append("interfaces:");
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            sb.append(ApiConst.NL).append("  ").append(iface);
            ClassLoader loader = iface.getClassLoader();
            sb.append(ApiConst.NL).append("    class loader: ").append(loader);
            ProtectionDomain pd = iface.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            sb.append(ApiConst.NL).append("    code source: ").append(cs);
        }
        sb.append(ApiConst.NL).append("ctx class loader:").append(ApiConst.NL);
        sb.append(ApiDebug.getClassLoaderInfo(Thread.currentThread().getContextClassLoader()));
        return sb.toString();
    }

    public static String getClassLoaderInfo(ClassLoader cl) {
        StringBuilder sb = new StringBuilder();
        ClassLoader parent = cl;
        while (parent != null) {
            sb.append(parent);
            URL[] urls = ApiDebug.getClassLoaderURLs(parent);
            if (urls != null) {
                if (urls.length == 0) {
                    sb.append(ApiConst.NL).append("  empty URLs");
                }
                for (URL url : urls) {
                    sb.append(ApiConst.NL).append("  ").append(url);
                }
            } else {
                sb.append(ApiConst.NL).append("  no URLs");
            }
            if ((parent = parent.getParent()) == null) continue;
            sb.append(ApiConst.NL);
        }
        return sb.toString();
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                Object[] args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return urls;
    }
}

