/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log;

import com.quartzdesk.api.ApiConst;
import com.quartzdesk.api.ApiDebug;
import com.quartzdesk.api.agent.log.LoggingInterceptorWrapperException;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class LoggingInterceptorWrapper {
    public static final MessagePriority DEFAULT_MESSAGE_PRIORITY = MessagePriority.INFO;
    private static final String FQCN_AGENT = "com.quartzdesk.agent.Agent";
    private static final String FQCN_AGENT_LOGGING_INTERCEPTOR_EVENT = "com.quartzdesk.agent.api.domain.model.log.LoggingEvent";
    private static final String FQCN_AGENT_LOGGING_INTERCEPTOR_EVENT_PRIORITY = "com.quartzdesk.agent.api.domain.model.log.LoggingEventPriority";
    private Object loggingInterceptor;
    private Class<?> loggingInterceptorEventClass;
    private Class<?> loggingInterceptorEventPriorityClass;
    private Method isInterceptingMethod;
    private Method interceptMethod;
    private Method setMessageMethod;
    private Method setPriorityMethod;

    private LoggingInterceptorWrapper(Object loggingInterceptor) throws ClassNotFoundException, NoSuchMethodException {
        this.loggingInterceptor = loggingInterceptor;
        Class<?> loggingInterceptorClass = loggingInterceptor.getClass();
        ClassLoader loggingInterceptorClassLoader = loggingInterceptorClass.getClassLoader();
        this.loggingInterceptorEventClass = Class.forName(FQCN_AGENT_LOGGING_INTERCEPTOR_EVENT, true, loggingInterceptorClassLoader);
        this.loggingInterceptorEventPriorityClass = Class.forName(FQCN_AGENT_LOGGING_INTERCEPTOR_EVENT_PRIORITY, true, loggingInterceptorClassLoader);
        this.isInterceptingMethod = loggingInterceptorClass.getMethod("isIntercepting", Thread.class);
        this.interceptMethod = loggingInterceptorClass.getMethod("intercept", Thread.class, this.loggingInterceptorEventClass);
        this.setMessageMethod = this.loggingInterceptorEventClass.getMethod("setMessage", String.class);
        this.setPriorityMethod = this.loggingInterceptorEventClass.getMethod("setPriority", this.loggingInterceptorEventPriorityClass);
    }

    public static LoggingInterceptorWrapper create() throws LoggingInterceptorWrapperException {
        try {
            Class<?> agentClass = Class.forName(FQCN_AGENT, true, Thread.currentThread().getContextClassLoader());
            Method getInstanceMethod = agentClass.getMethod("getInstance", new Class[0]);
            int getInstanceModifiers = getInstanceMethod.getModifiers();
            if (Modifier.isPublic(getInstanceModifiers) && Modifier.isStatic(getInstanceModifiers)) {
                Object agent = getInstanceMethod.invoke(null, new Object[0]);
                if (agent == null) {
                    throw new LoggingInterceptorWrapperException("Error initializing " + LoggingInterceptorWrapper.class.getName() + ": " + FQCN_AGENT + ".getInstance method returned null.");
                }
                Method getLoggingInterceptorMethod = agentClass.getMethod("getExecutingJobLoggingInterceptor", new Class[0]);
                Object loggingInterceptor = getLoggingInterceptorMethod.invoke(agent, new Object[0]);
                if (loggingInterceptor == null) {
                    throw new LoggingInterceptorWrapperException("Error initializing " + LoggingInterceptorWrapper.class.getName() + ": " + FQCN_AGENT + ".getExecutingJobLoggingInterceptor method returned null.");
                }
                return new LoggingInterceptorWrapper(loggingInterceptor);
            }
            throw new LoggingInterceptorWrapperException("Error initializing " + LoggingInterceptorWrapper.class.getName() + ": " + FQCN_AGENT + ".getInstance method is not public static.");
        }
        catch (LoggingInterceptorWrapperException e) {
            LoggingInterceptorWrapper.logWarningException(e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            LoggingInterceptorWrapper.logWarningException(e);
            throw new LoggingInterceptorWrapperException("Error initializing " + LoggingInterceptorWrapper.class.getName() + ": QuartzDesk JVM Agent is not installed (is not on the classpath). Context thread class loader: " + ApiConst.NL + ApiDebug.getClassLoaderInfo(Thread.currentThread().getContextClassLoader()), e);
        }
        catch (Exception e) {
            LoggingInterceptorWrapper.logWarningException(e);
            throw new LoggingInterceptorWrapperException("Error initializing " + LoggingInterceptorWrapper.class.getName() + ": " + e.toString(), e);
        }
    }

    public boolean isIntercepting(Thread jobThread) {
        try {
            return (Boolean)this.isInterceptingMethod.invoke(this.loggingInterceptor, jobThread);
        }
        catch (Exception e) {
            LoggingInterceptorWrapper.logError("Error invoking isIntercepting(Thread) method on " + this.loggingInterceptor, e);
            return false;
        }
    }

    public void intercept(Thread thread, MessagePriority priority, String message) {
        try {
            Object loggingEvent = this.loggingInterceptorEventClass.newInstance();
            this.setPriorityMethod.invoke(loggingEvent, this.convertToAgentLoggingEventPriority(priority));
            this.setMessageMethod.invoke(loggingEvent, message);
            Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(thread);
            if (jobThread == null) {
                jobThread = thread;
            }
            this.interceptMethod.invoke(this.loggingInterceptor, jobThread, loggingEvent);
        }
        catch (Exception e) {
            LoggingInterceptorWrapper.logError("Error invoking intercept(Thread, LoggingEvent) method on " + this.loggingInterceptor, e);
        }
    }

    private Object convertToAgentLoggingEventPriority(MessagePriority priority) {
        for (Object enumValueObj : this.loggingInterceptorEventPriorityClass.getEnumConstants()) {
            Enum enumValue = (Enum)enumValueObj;
            if (!priority.name().equals(enumValue.name())) continue;
            return enumValueObj;
        }
        throw new IllegalArgumentException("Error converting " + MessagePriority.class.getName() + " value: " + (Object)((Object)priority) + " to " + FQCN_AGENT_LOGGING_INTERCEPTOR_EVENT_PRIORITY + " value.");
    }

    private static void logWarningException(Throwable e) {
        System.out.println("=== WARNING (source: " + LoggingInterceptorWrapper.class.getName() + ") === ");
        e.printStackTrace(System.out);
        System.out.println("===");
    }

    private static void logError(String error, Throwable e) {
        System.out.println("=== ERROR (source: " + LoggingInterceptorWrapper.class.getName() + ") === ");
        System.out.println(error);
        if (e != null) {
            e.printStackTrace(System.out);
        }
        System.out.println("===");
    }

    public static enum MessagePriority {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

