/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WorkerThreadLoggingInterceptorRegistry {
    public static final WorkerThreadLoggingInterceptorRegistry INSTANCE = new WorkerThreadLoggingInterceptorRegistry();
    private Map<Thread, Thread> registry = new ConcurrentHashMap<Thread, Thread>();

    private WorkerThreadLoggingInterceptorRegistry() {
    }

    public Thread getJobThreadForWorkerThread(Thread workerThread) {
        return this.registry.get(workerThread);
    }

    public void startIntercepting(Thread jobThread) {
        Thread currentThread = Thread.currentThread();
        if (currentThread == jobThread) {
            throw new IllegalStateException("The job thread argument must not be the current worker thread. It must be the main job thread that spawned or is using the current worker thread.");
        }
        this.registry.put(currentThread, jobThread);
    }

    public void stopIntercepting() {
        this.registry.remove(Thread.currentThread());
    }
}

