/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log.jul;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.IAgent;
import com.quartzdesk.agent.api.domain.model.log.LoggingEvent;
import com.quartzdesk.agent.api.domain.model.log.LoggingEventPriority;
import com.quartzdesk.agent.api.scheduler.common.log.IExecutingJobLoggingInterceptor;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

@Deprecated
public class ClassicJulInterceptionHandler<E>
extends Handler {
    private static final LoggingEventPriority DEFAULT_LOGGING_INTERCEPTOR_EVENT_PRIORITY = LoggingEventPriority.INFO;
    private IExecutingJobLoggingInterceptor loggingInterceptor;

    public ClassicJulInterceptionHandler() {
        String cname = this.getClass().getName();
        this.setLevel(this.getLevelProperty(cname + ".level", Level.INFO));
        this.setFilter(this.getFilterProperty(cname + ".filter", null));
        this.setFormatter(this.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
    }

    @Override
    public void publish(LogRecord record) {
        if (this.loggingInterceptor == null) {
            IAgent agent = Agent.getInstance();
            this.loggingInterceptor = agent.getExecutingJobLoggingInterceptor();
        }
        if (this.isLoggable(record)) {
            Thread currentThread = Thread.currentThread();
            Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(currentThread);
            if (jobThread == null) {
                jobThread = currentThread;
            }
            if (this.loggingInterceptor != null && this.loggingInterceptor.isIntercepting(jobThread)) {
                LoggingEvent loggingInterceptorEvent = new LoggingEvent().withPriority(this.convertLevel2Priority(record.getLevel())).withMessage(this.getFormatter().format(record));
                this.loggingInterceptor.intercept(jobThread, loggingInterceptorEvent);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.loggingInterceptor = null;
    }

    protected Level getLevelProperty(String name, Level defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected Filter getFilterProperty(String name, Filter defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    protected Formatter getFormatterProperty(String name, Formatter defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    protected LoggingEventPriority convertLevel2Priority(Level level) {
        if (level.equals(Level.FINEST)) {
            return LoggingEventPriority.TRACE;
        }
        if (level.equals(Level.FINER)) {
            return LoggingEventPriority.TRACE;
        }
        if (level.equals(Level.FINE)) {
            return LoggingEventPriority.DEBUG;
        }
        if (level.equals(Level.CONFIG)) {
            return LoggingEventPriority.INFO;
        }
        if (level.equals(Level.INFO)) {
            return LoggingEventPriority.INFO;
        }
        if (level.equals(Level.WARNING)) {
            return LoggingEventPriority.WARN;
        }
        if (level.equals(Level.SEVERE)) {
            return LoggingEventPriority.ERROR;
        }
        this.reportError("Cannot map logging level: " + level + ". Using default logging interceptor event priority: " + DEFAULT_LOGGING_INTERCEPTOR_EVENT_PRIORITY, null, 0);
        return DEFAULT_LOGGING_INTERCEPTOR_EVENT_PRIORITY;
    }
}

