/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log.jul;

import com.quartzdesk.api.agent.log.LoggingInterceptorWrapper;
import com.quartzdesk.api.agent.log.LoggingInterceptorWrapperException;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class JulInterceptionHandler<E>
extends Handler {
    private boolean loggingInterceptorInitError;
    private LoggingInterceptorWrapper loggingInterceptor;

    public JulInterceptionHandler() {
        String cname = this.getClass().getName();
        this.setLevel(this.getLevelProperty(cname + ".level", Level.INFO));
        this.setFilter(this.getFilterProperty(cname + ".filter", null));
        this.setFormatter(this.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
    }

    @Override
    public void publish(LogRecord record) {
        if (this.loggingInterceptorInitError) {
            return;
        }
        if (this.loggingInterceptor == null) {
            try {
                this.loggingInterceptor = LoggingInterceptorWrapper.create();
            }
            catch (LoggingInterceptorWrapperException e) {
                this.loggingInterceptorInitError = true;
                this.reportError("Cannot initialize " + LoggingInterceptorWrapper.class.getName() + ". Handler " + this.getClass().getName() + " will be disabled. Cause: " + e.getMessage(), null, 0);
            }
        }
        if (this.loggingInterceptor != null && this.isLoggable(record)) {
            Thread currentThread = Thread.currentThread();
            Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(currentThread);
            if (jobThread == null) {
                jobThread = currentThread;
            }
            if (this.loggingInterceptor.isIntercepting(jobThread)) {
                LoggingInterceptorWrapper.MessagePriority priority = this.convertLevel2Priority(record.getLevel());
                String message = this.getFormatter().format(record);
                this.loggingInterceptor.intercept(jobThread, priority, message);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.loggingInterceptor = null;
    }

    protected Level getLevelProperty(String name, Level defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected Filter getFilterProperty(String name, Filter defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    protected Formatter getFormatterProperty(String name, Formatter defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    protected LoggingInterceptorWrapper.MessagePriority convertLevel2Priority(Level level) {
        if (level.equals(Level.FINEST)) {
            return LoggingInterceptorWrapper.MessagePriority.TRACE;
        }
        if (level.equals(Level.FINER)) {
            return LoggingInterceptorWrapper.MessagePriority.TRACE;
        }
        if (level.equals(Level.FINE)) {
            return LoggingInterceptorWrapper.MessagePriority.DEBUG;
        }
        if (level.equals(Level.CONFIG)) {
            return LoggingInterceptorWrapper.MessagePriority.INFO;
        }
        if (level.equals(Level.INFO)) {
            return LoggingInterceptorWrapper.MessagePriority.INFO;
        }
        if (level.equals(Level.WARNING)) {
            return LoggingInterceptorWrapper.MessagePriority.WARN;
        }
        if (level.equals(Level.SEVERE)) {
            return LoggingInterceptorWrapper.MessagePriority.ERROR;
        }
        this.reportError("Cannot map logging level: " + level + ". Using default message priority: " + (Object)((Object)LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY), null, 0);
        return LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY;
    }
}

