/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log.log4j;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.IAgent;
import com.quartzdesk.agent.api.domain.model.log.LoggingEventPriority;
import com.quartzdesk.agent.api.scheduler.common.log.IExecutingJobLoggingInterceptor;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

@Deprecated
public class ClassicLog4jInterceptionAppender
extends AppenderSkeleton {
    private static final LoggingEventPriority LOGGING_INTERCEPTOR_EVENT_PRIORITY = LoggingEventPriority.INFO;
    private IExecutingJobLoggingInterceptor loggingInterceptor;

    public ClassicLog4jInterceptionAppender() {
        this.setName("QuartzDesk-" + ClassicLog4jInterceptionAppender.class.getSimpleName());
        IAgent agent = Agent.getInstance();
        this.loggingInterceptor = agent.getExecutingJobLoggingInterceptor();
    }

    public void close() {
        this.loggingInterceptor = null;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        Thread currentThread = Thread.currentThread();
        Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(currentThread);
        if (jobThread == null) {
            jobThread = currentThread;
        }
        if (this.loggingInterceptor != null && this.loggingInterceptor.isIntercepting(jobThread)) {
            String[] traceLines;
            com.quartzdesk.agent.api.domain.model.log.LoggingEvent loggingInterceptorEvent = new com.quartzdesk.agent.api.domain.model.log.LoggingEvent().withPriority(this.convertLevel2Priority(event.getLevel()));
            StringBuilder msg = new StringBuilder(this.getLayout().format(event));
            if (this.layout.ignoresThrowable() && (traceLines = event.getThrowableStrRep()) != null) {
                for (String traceLine : traceLines) {
                    msg.append(traceLine);
                    msg.append(Layout.LINE_SEP);
                }
            }
            loggingInterceptorEvent.setMessage(msg.toString());
            this.loggingInterceptor.intercept(jobThread, loggingInterceptorEvent);
        }
    }

    protected LoggingEventPriority convertLevel2Priority(Level level) {
        if (level.equals((Object)Level.TRACE)) {
            return LoggingEventPriority.TRACE;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return LoggingEventPriority.DEBUG;
        }
        if (level.equals((Object)Level.INFO)) {
            return LoggingEventPriority.INFO;
        }
        if (level.equals((Object)Level.WARN)) {
            return LoggingEventPriority.WARN;
        }
        if (level.equals((Object)Level.ERROR)) {
            return LoggingEventPriority.ERROR;
        }
        if (level.equals((Object)Level.FATAL)) {
            return LoggingEventPriority.ERROR;
        }
        LogLog.warn((String)("Cannot map logging level: " + level + ". Using default logging interceptor event priority: " + LOGGING_INTERCEPTOR_EVENT_PRIORITY));
        return LOGGING_INTERCEPTOR_EVENT_PRIORITY;
    }
}

