/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log.log4j;

import com.quartzdesk.api.agent.log.LoggingInterceptorWrapper;
import com.quartzdesk.api.agent.log.LoggingInterceptorWrapperException;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jInterceptionAppender
extends AppenderSkeleton {
    private LoggingInterceptorWrapper loggingInterceptor;

    public Log4jInterceptionAppender() {
        this.setName("QuartzDesk-" + Log4jInterceptionAppender.class.getSimpleName());
        try {
            this.loggingInterceptor = LoggingInterceptorWrapper.create();
        }
        catch (LoggingInterceptorWrapperException e) {
            LogLog.warn((String)("Cannot initialize " + LoggingInterceptorWrapper.class.getName() + ". Appender " + this.getName() + " will be disabled. Cause: " + e.getMessage()));
        }
    }

    public void close() {
        this.loggingInterceptor = null;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        Thread currentThread = Thread.currentThread();
        Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(currentThread);
        if (jobThread == null) {
            jobThread = currentThread;
        }
        if (this.loggingInterceptor != null && this.loggingInterceptor.isIntercepting(jobThread)) {
            String[] traceLines;
            LoggingInterceptorWrapper.MessagePriority priority = this.convertLevel2Priority(event.getLevel());
            StringBuilder msg = new StringBuilder(this.getLayout().format(event));
            if (this.layout.ignoresThrowable() && (traceLines = event.getThrowableStrRep()) != null) {
                for (String traceLine : traceLines) {
                    msg.append(traceLine);
                    msg.append(Layout.LINE_SEP);
                }
            }
            this.loggingInterceptor.intercept(jobThread, priority, msg.toString());
        }
    }

    protected LoggingInterceptorWrapper.MessagePriority convertLevel2Priority(Level level) {
        if (level.equals((Object)Level.TRACE)) {
            return LoggingInterceptorWrapper.MessagePriority.TRACE;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return LoggingInterceptorWrapper.MessagePriority.DEBUG;
        }
        if (level.equals((Object)Level.INFO)) {
            return LoggingInterceptorWrapper.MessagePriority.INFO;
        }
        if (level.equals((Object)Level.WARN)) {
            return LoggingInterceptorWrapper.MessagePriority.WARN;
        }
        if (level.equals((Object)Level.ERROR)) {
            return LoggingInterceptorWrapper.MessagePriority.ERROR;
        }
        if (level.equals((Object)Level.FATAL)) {
            return LoggingInterceptorWrapper.MessagePriority.ERROR;
        }
        LogLog.warn((String)("Cannot map logging level: " + level + ". Using default message priority: " + (Object)((Object)LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY)));
        return LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY;
    }
}

