/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log.log4j2;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.IAgent;
import com.quartzdesk.agent.api.domain.model.log.LoggingEvent;
import com.quartzdesk.agent.api.domain.model.log.LoggingEventPriority;
import com.quartzdesk.agent.api.scheduler.common.log.IExecutingJobLoggingInterceptor;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Charsets;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Deprecated
public class ClassicLog4j2InterceptionAppender<T extends Serializable>
extends AbstractAppender<T> {
    private static final LoggingEventPriority DEFAULT_LOGGING_INTERCEPTOR_EVENT_PRIORITY = LoggingEventPriority.INFO;
    private IExecutingJobLoggingInterceptor loggingInterceptor;

    protected ClassicLog4j2InterceptionAppender(String name, Filter filter, Layout<T> layout, boolean handleException) {
        super(name, filter, layout, handleException);
        IAgent agent = Agent.getInstance();
        LOGGER.info("Starting " + ClassicLog4j2InterceptionAppender.class.getName() + " for " + agent);
        this.loggingInterceptor = agent.getExecutingJobLoggingInterceptor();
    }

    @PluginFactory
    public static <T extends Serializable> ClassicLog4j2InterceptionAppender<T> createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppress, @PluginElement(value="layout") Layout<T> layout, @PluginElement(value="filters") Filter filter) {
        boolean handleExceptions;
        boolean bl = handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        if (name == null) {
            LOGGER.error("No name provided for QuartzDeskAppender appender.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null, null);
        }
        return new ClassicLog4j2InterceptionAppender<T>(name, filter, layout, handleExceptions);
    }

    public void append(LogEvent event) {
        Thread currentThread = Thread.currentThread();
        Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(currentThread);
        if (jobThread == null) {
            jobThread = currentThread;
        }
        if (this.loggingInterceptor != null && this.loggingInterceptor.isIntercepting(jobThread)) {
            LoggingEvent loggingInterceptorEvent = new LoggingEvent().withPriority(this.convertLevel2Priority(event.getLevel()));
            Layout layout = this.getLayout();
            if (layout instanceof AbstractStringLayout) {
                byte[] eventBytes = layout.toByteArray(event);
                Charset charset = this.getLayoutCharset((AbstractStringLayout)layout);
                loggingInterceptorEvent.setMessage(new String(eventBytes, charset));
                this.loggingInterceptor.intercept(jobThread, loggingInterceptorEvent);
            } else {
                LOGGER.error("Layout in QuartzDeskAppender must extend AbstractStringLayout. It is typically PatternLayout.");
            }
        }
    }

    protected LoggingEventPriority convertLevel2Priority(Level level) {
        if (level.equals((Object)Level.TRACE)) {
            return LoggingEventPriority.TRACE;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return LoggingEventPriority.DEBUG;
        }
        if (level.equals((Object)Level.INFO)) {
            return LoggingEventPriority.INFO;
        }
        if (level.equals((Object)Level.WARN)) {
            return LoggingEventPriority.WARN;
        }
        if (level.equals((Object)Level.ERROR)) {
            return LoggingEventPriority.ERROR;
        }
        if (level.equals((Object)Level.FATAL)) {
            return LoggingEventPriority.ERROR;
        }
        LOGGER.warn("Cannot map logging level: " + level + ". Using default logging interceptor event priority: " + DEFAULT_LOGGING_INTERCEPTOR_EVENT_PRIORITY);
        return DEFAULT_LOGGING_INTERCEPTOR_EVENT_PRIORITY;
    }

    protected <L extends AbstractStringLayout> Charset getLayoutCharset(L layout) {
        try {
            Method method = this.getCharsetMethod(layout.getClass());
            if (method != null) {
                method.setAccessible(true);
                Object result = method.invoke(layout, new Object[0]);
                if (result != null && result instanceof Charset) {
                    return (Charset)result;
                }
            }
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Charsets.getSupportedCharset((String)Charsets.UTF_8.name());
    }

    private Method getCharsetMethod(Class<?> clazz) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod("getCharset", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }
}

