/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log.log4j2;

import com.quartzdesk.api.agent.log.LoggingInterceptorWrapper;
import com.quartzdesk.api.agent.log.LoggingInterceptorWrapperException;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Charsets;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="QuartzDeskJvmAgent", category="Core", elementType="appender", printObject=true)
public class Log4j2InterceptionAppender<T extends Serializable>
extends AbstractAppender<T> {
    private LoggingInterceptorWrapper loggingInterceptor;

    protected Log4j2InterceptionAppender(String name, Filter filter, Layout<T> layout, boolean handleException) {
        super(name, filter, layout, handleException);
        LOGGER.info("Starting " + Log4j2InterceptionAppender.class.getName() + ", name=" + name);
        try {
            this.loggingInterceptor = LoggingInterceptorWrapper.create();
        }
        catch (LoggingInterceptorWrapperException e) {
            LOGGER.warn("Cannot initialize " + LoggingInterceptorWrapper.class.getName() + ". Appender " + this.getName() + " will be disabled. Cause: " + e.getMessage());
        }
    }

    @PluginFactory
    public static <T extends Serializable> Log4j2InterceptionAppender<T> createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppress, @PluginElement(value="layout") Layout<T> layout, @PluginElement(value="filters") Filter filter) {
        boolean handleExceptions;
        boolean bl = handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        if (name == null) {
            LOGGER.error("No name provided for QuartzDeskAppender appender.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null, null);
        }
        return new Log4j2InterceptionAppender<T>(name, filter, layout, handleExceptions);
    }

    public void append(LogEvent event) {
        Thread currentThread = Thread.currentThread();
        Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(currentThread);
        if (jobThread == null) {
            jobThread = currentThread;
        }
        if (this.loggingInterceptor != null && this.loggingInterceptor.isIntercepting(jobThread)) {
            LoggingInterceptorWrapper.MessagePriority priority = this.convertLevel2Priority(event.getLevel());
            Layout layout = this.getLayout();
            if (layout instanceof AbstractStringLayout) {
                byte[] eventBytes = layout.toByteArray(event);
                Charset charset = this.getLayoutCharset((AbstractStringLayout)layout);
                String message = new String(eventBytes, charset);
                this.loggingInterceptor.intercept(jobThread, priority, message);
            } else {
                LOGGER.error("Layout in QuartzDeskAppender must extend AbstractStringLayout. It is typically PatternLayout.");
            }
        }
    }

    protected LoggingInterceptorWrapper.MessagePriority convertLevel2Priority(Level level) {
        if (level.equals((Object)Level.TRACE)) {
            return LoggingInterceptorWrapper.MessagePriority.TRACE;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return LoggingInterceptorWrapper.MessagePriority.DEBUG;
        }
        if (level.equals((Object)Level.INFO)) {
            return LoggingInterceptorWrapper.MessagePriority.INFO;
        }
        if (level.equals((Object)Level.WARN)) {
            return LoggingInterceptorWrapper.MessagePriority.WARN;
        }
        if (level.equals((Object)Level.ERROR)) {
            return LoggingInterceptorWrapper.MessagePriority.ERROR;
        }
        if (level.equals((Object)Level.FATAL)) {
            return LoggingInterceptorWrapper.MessagePriority.ERROR;
        }
        LOGGER.warn("Cannot map logging level: " + level + ". Using default message priority: " + (Object)((Object)LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY));
        return LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY;
    }

    protected <L extends AbstractStringLayout> Charset getLayoutCharset(L layout) {
        try {
            Method method = this.getCharsetMethod(layout.getClass());
            if (method != null) {
                method.setAccessible(true);
                Object result = method.invoke(layout, new Object[0]);
                if (result != null && result instanceof Charset) {
                    return (Charset)result;
                }
            }
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Charsets.getSupportedCharset((String)Charsets.UTF_8.name());
    }

    private Method getCharsetMethod(Class<?> clazz) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod("getCharset", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }
}

