/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.quartzdesk.api.agent.log.LoggingInterceptorWrapper;
import com.quartzdesk.api.agent.log.LoggingInterceptorWrapperException;
import com.quartzdesk.api.agent.log.WorkerThreadLoggingInterceptorRegistry;

public class LogbackInterceptionAppender<E>
extends AppenderBase<E> {
    protected Layout<E> layout;
    private LoggingInterceptorWrapper loggingInterceptor;

    public LogbackInterceptionAppender() {
        this.setName("QuartzDesk-" + LogbackInterceptionAppender.class.getSimpleName());
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public void start() {
        this.addInfo("Starting " + LogbackInterceptionAppender.class.getName());
        try {
            this.loggingInterceptor = LoggingInterceptorWrapper.create();
        }
        catch (LoggingInterceptorWrapperException e) {
            this.addWarn("Cannot initialize " + LoggingInterceptorWrapper.class.getName() + ". Appender " + ((Object)((Object)this)).getClass().getName() + " will be disabled. Cause: " + e.getMessage());
        }
        super.start();
    }

    public void stop() {
        this.loggingInterceptor = null;
        super.stop();
    }

    protected void append(E eventObject) {
        Thread currentThread = Thread.currentThread();
        Thread jobThread = WorkerThreadLoggingInterceptorRegistry.INSTANCE.getJobThreadForWorkerThread(currentThread);
        if (jobThread == null) {
            jobThread = currentThread;
        }
        if (this.loggingInterceptor != null && this.loggingInterceptor.isIntercepting(jobThread)) {
            LoggingEvent loggingEvent = (LoggingEvent)eventObject;
            LoggingInterceptorWrapper.MessagePriority priority = this.convertLevel2Priority(loggingEvent.getLevel());
            String message = this.layout.doLayout(eventObject);
            this.loggingInterceptor.intercept(jobThread, priority, message);
        }
    }

    protected LoggingInterceptorWrapper.MessagePriority convertLevel2Priority(Level level) {
        if (level.equals(Level.TRACE)) {
            return LoggingInterceptorWrapper.MessagePriority.TRACE;
        }
        if (level.equals(Level.DEBUG)) {
            return LoggingInterceptorWrapper.MessagePriority.DEBUG;
        }
        if (level.equals(Level.INFO)) {
            return LoggingInterceptorWrapper.MessagePriority.INFO;
        }
        if (level.equals(Level.WARN)) {
            return LoggingInterceptorWrapper.MessagePriority.WARN;
        }
        if (level.equals(Level.ERROR)) {
            return LoggingInterceptorWrapper.MessagePriority.ERROR;
        }
        this.addWarn("Cannot map logging level: " + level + ". Using default message priority: " + (Object)((Object)LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY));
        return LoggingInterceptorWrapper.DEFAULT_MESSAGE_PRIORITY;
    }
}

