/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v1_8_x;

import com.quartzdesk.agent.api.AgentException;
import com.quartzdesk.agent.api.common.CommonUtils;
import com.quartzdesk.agent.api.domain.convert.common.VersionConverter;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTriggerType;
import com.quartzdesk.agent.api.scheduler.quartz.QuartzEvent;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.listener.QuartzJobListener;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.listener.QuartzSchedulerListener;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.listener.QuartzTriggerListener;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.quartz.CronTrigger;
import org.quartz.DateIntervalTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobListener;
import org.quartz.NthIncludedDayTrigger;
import org.quartz.SchedulerListener;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;

public final class QuartzApiUtils {
    private static final Logger log = LoggerFactory.getLogger(QuartzApiUtils.class);

    private QuartzApiUtils() {
    }

    public static void registerInternalListeners(QuartzScheduler quartzScheduler) {
        ObjectName schedObjectName = QuartzApiUtils.getSchedulerObjectName(quartzScheduler);
        QuartzSchedulerListener schedulerListener = new QuartzSchedulerListener(quartzScheduler);
        log.debug("Adding QuartzDesk scheduler listener: {} to Quartz scheduler: {}", (Object)schedulerListener, (Object)schedObjectName);
        quartzScheduler.addSchedulerListener((SchedulerListener)schedulerListener);
        QuartzJobListener jobListener = new QuartzJobListener(quartzScheduler);
        log.debug("Adding QuartzDesk job listener: {} to Quartz scheduler: {}", (Object)jobListener, (Object)schedObjectName);
        quartzScheduler.addGlobalJobListener((JobListener)jobListener);
        QuartzTriggerListener triggerListener = new QuartzTriggerListener(quartzScheduler);
        log.debug("Adding QuartzDesk trigger listener: {} to Quartz scheduler: {}", (Object)triggerListener, (Object)schedObjectName);
        quartzScheduler.addGlobalTriggerListener((TriggerListener)triggerListener);
    }

    public static ObjectName getSchedulerObjectName(QuartzScheduler quartzScheduler) {
        try {
            Class<?> quartzSchedulerClass = quartzScheduler.getClass();
            Field resourcesField = quartzSchedulerClass.getDeclaredField("resources");
            resourcesField.setAccessible(true);
            QuartzSchedulerResources resources = (QuartzSchedulerResources)resourcesField.get(quartzScheduler);
            return new ObjectName(resources.getJMXObjectName());
        }
        catch (Exception e) {
            throw new AgentException("Cannot obtain object name of the MBean wrapping Quartz scheduler instance: " + quartzScheduler, (Throwable)e);
        }
    }

    public static <T extends QuartzEvent> T prepareEvent(Class<T> schedulerEventType, QuartzScheduler quartzScheduler) {
        try {
            QuartzEvent schedulerEvent = (QuartzEvent)schedulerEventType.newInstance();
            schedulerEvent.setScheduler((Object)quartzScheduler);
            schedulerEvent.setSchedulerObjectName(QuartzApiUtils.getSchedulerObjectName(quartzScheduler));
            schedulerEvent.setSchedulerVersion(VersionConverter.INSTANCE.fromString(quartzScheduler.getVersion()));
            schedulerEvent.setSchedulerName(quartzScheduler.getSchedulerName());
            schedulerEvent.setSchedulerInstanceId(quartzScheduler.getSchedulerInstanceId());
            return (T)schedulerEvent;
        }
        catch (Exception e) {
            throw new AgentException("Error preparing Quartz scheduler event.", (Throwable)e);
        }
    }

    public static <T extends Trigger> QuartzTriggerType getTriggerType(T quartzTrigger) {
        if (quartzTrigger instanceof SimpleTrigger) {
            return QuartzTriggerType.SIMPLE;
        }
        if (quartzTrigger instanceof CronTrigger) {
            return QuartzTriggerType.CRON;
        }
        if (quartzTrigger instanceof DateIntervalTrigger) {
            return QuartzTriggerType.DATE_INTERVAL;
        }
        if (quartzTrigger instanceof NthIncludedDayTrigger) {
            return QuartzTriggerType.NTH_INCLUDED_DAY;
        }
        throw new AgentException("Unrecognized trigger type: " + quartzTrigger);
    }

    public static Map<String, String> toEventJobDataMap(JobDataMap quartzJobDataMap) {
        LinkedHashMap<String, String> jobDataMap = new LinkedHashMap<String, String>();
        for (Map.Entry qEntry : quartzJobDataMap.entrySet()) {
            Object qKey = qEntry.getKey();
            Object qValue = qEntry.getValue();
            jobDataMap.put(qKey.toString(), CommonUtils.safeToString(qValue));
        }
        return jobDataMap;
    }
}

