/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v1_8_x;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.IAgent;
import com.quartzdesk.agent.api.common.CommonConst;
import com.quartzdesk.agent.api.common.CommonUtils;
import com.quartzdesk.agent.api.domain.convert.common.VersionConverter;
import com.quartzdesk.agent.api.domain.model.agent.RegisteredSchedulerInfo;
import com.quartzdesk.agent.api.domain.model.common.Version;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDetail;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobListener;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzPlannedJobExecution;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzPlannedJobExecutions;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzSchedulerListener;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTriggerListener;
import com.quartzdesk.agent.api.domain.type.TimestampWithTZ;
import com.quartzdesk.agent.api.index.IIndex;
import com.quartzdesk.agent.api.index.IIndexQueryCriteria;
import com.quartzdesk.agent.api.index.jobs.QuartzJobsQueryCriteria;
import com.quartzdesk.agent.api.index.triggers.QuartzTriggersQueryCriteria;
import com.quartzdesk.agent.api.jmx_connector.scheduler.quartz.support.QuartzJobDetailMBeanTypeSupport;
import com.quartzdesk.agent.api.jmx_connector.scheduler.quartz.support.QuartzJobListenerMBeanTypeSupport;
import com.quartzdesk.agent.api.jmx_connector.scheduler.quartz.support.QuartzPlannedJobExecutionsMBeanTypeSupport;
import com.quartzdesk.agent.api.jmx_connector.scheduler.quartz.support.QuartzSchedulerListenerMBeanTypeSupport;
import com.quartzdesk.agent.api.jmx_connector.scheduler.quartz.support.QuartzTriggerListenerMBeanTypeSupport;
import com.quartzdesk.agent.api.jmx_connector.scheduler.quartz.support.QuartzTriggerMBeanTypeSupport;
import com.quartzdesk.agent.api.jmx_connector.support.common.ClassDescMBeanTypeSupport;
import com.quartzdesk.agent.api.jmx_connector.support.common.TimestampWithTZMBeanTypeSupport;
import com.quartzdesk.agent.api.scheduler.quartz.health.exec.IQuartzExecHealthIndicators;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.QuartzApiUtils;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.jmx.Domain2QuartzTriggerConverter;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.jmx.Quartz2DomainJobDetailConverter;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.jmx.Quartz2DomainTriggerConverter;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.SchedulingContext;

public class QuartzSchedulerMBeanImplExtensions {
    private static final Logger log = LoggerFactory.getLogger(QuartzSchedulerMBeanImplExtensions.class);
    private static final Comparator<QuartzPlannedJobExecution> PLANNED_JOB_EXECUTION_COMPARATOR = new Comparator<QuartzPlannedJobExecution>(){

        @Override
        public int compare(QuartzPlannedJobExecution plannedExecution1, QuartzPlannedJobExecution plannedExecution2) {
            return CommonUtils.safeCompare((Comparable)plannedExecution1.getFireTime(), (Comparable)plannedExecution2.getFireTime());
        }
    };
    private QuartzScheduler scheduler;
    private Version schedulerVersion;

    public QuartzSchedulerMBeanImplExtensions(QuartzScheduler scheduler) {
        this.scheduler = scheduler;
        this.schedulerVersion = VersionConverter.INSTANCE.fromString(scheduler.getVersion());
    }

    public CompositeData getJobDetail(String instanceId, String jobName, String jobGroupName) throws Exception {
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            JobDetail quartzJobDetail = this.scheduler.getJobDetail(ctx, jobName, jobGroupName);
            if (quartzJobDetail == null) {
                return null;
            }
            Quartz2DomainJobDetailConverter jobDetailConverter = new Quartz2DomainJobDetailConverter(this.schedulerVersion);
            QuartzJobDetail jobDetail = jobDetailConverter.convertJobDetail(quartzJobDetail);
            this.setJobNextFireTime(instanceId, jobDetail);
            this.setJobExecHealthIndicator(instanceId, jobDetail);
            return QuartzJobDetailMBeanTypeSupport.toCompositeData((QuartzJobDetail)jobDetail);
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    public CompositeData[] getJobDetails(String instanceId, String filterJobGroupName, String filterQuery) throws Exception {
        List<QuartzJobDetail> jobDetails = this.getJobDetails(instanceId, filterJobGroupName, filterQuery, true, true);
        return QuartzJobDetailMBeanTypeSupport.toCompositeDataArray(jobDetails);
    }

    public CompositeData[] getJobNextFireTimes(String instanceId, String jobName, String jobGroupName, Integer maxFetchSize) throws Exception {
        SchedulingContext ctx = new SchedulingContext(instanceId);
        JobDetail quartzJobDetail = this.scheduler.getJobDetail(ctx, jobName, jobGroupName);
        if (quartzJobDetail == null) {
            throw new SchedulerException("Job " + jobGroupName + '/' + jobName + " not found.");
        }
        List<TimestampWithTZ> fireTimesList = this.getJobFireTimes(instanceId, quartzJobDetail, new Date(), null, maxFetchSize);
        return TimestampWithTZMBeanTypeSupport.toCompositeDataArray(fireTimesList);
    }

    public CompositeData getPlannedJobExecutions(String instanceId, Date startTime, Date endTime, String jobGroupName, String filterQuery, Integer maxFetchSize, Locale locale) throws Exception {
        QuartzPlannedJobExecutions plannedJobExecutions = this.getPlannedJobExecutions0(instanceId, startTime, endTime, jobGroupName, filterQuery, maxFetchSize, locale);
        return QuartzPlannedJobExecutionsMBeanTypeSupport.toCompositeData((QuartzPlannedJobExecutions)plannedJobExecutions);
    }

    public void addTrigger(String instanceId, CompositeData compositeTrigger) throws Exception {
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            QuartzTrigger trigger = QuartzTriggerMBeanTypeSupport.fromCompositeData((CompositeData)compositeTrigger, (TimeZone)CommonConst.TIME_ZONE_UTC);
            Domain2QuartzTriggerConverter triggerConverter = new Domain2QuartzTriggerConverter(this.schedulerVersion);
            Object quartzTrigger = triggerConverter.convertTrigger(trigger);
            this.scheduler.scheduleJob(ctx, quartzTrigger);
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    public boolean updateTrigger(String instanceId, CompositeData compositeTrigger) throws Exception {
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            QuartzTrigger trigger = QuartzTriggerMBeanTypeSupport.fromCompositeData((CompositeData)compositeTrigger, (TimeZone)CommonConst.TIME_ZONE_UTC);
            Domain2QuartzTriggerConverter triggerConverter = new Domain2QuartzTriggerConverter(this.schedulerVersion);
            Object quartzTrigger = triggerConverter.convertTrigger(trigger);
            return this.scheduler.rescheduleJob(ctx, quartzTrigger.getName(), quartzTrigger.getGroup(), quartzTrigger) != null;
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    public CompositeData[] getAllTriggers(String instanceId, String filterQuery, Locale locale) throws Exception {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ArrayList<QuartzTrigger> triggers = new ArrayList<QuartzTrigger>();
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            Quartz2DomainTriggerConverter triggerConverter = new Quartz2DomainTriggerConverter(this.schedulerVersion);
            for (String triggerGroupName : this.scheduler.getTriggerGroupNames(ctx)) {
                for (String triggerName : this.scheduler.getTriggerNames(ctx, triggerGroupName)) {
                    Trigger quartzTrigger = this.scheduler.getTrigger(ctx, triggerName, triggerGroupName);
                    if (quartzTrigger == null) continue;
                    triggers.add((QuartzTrigger)triggerConverter.convertTrigger(quartzTrigger, locale));
                }
            }
            if (filterQuery != null) {
                ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
                IAgent agent = Agent.getInstance();
                IIndex triggersIndex = agent.getQuartzTriggerIndex(schedulerObjectName);
                QuartzTriggersQueryCriteria criteria = (QuartzTriggersQueryCriteria)((QuartzTriggersQueryCriteria)new QuartzTriggersQueryCriteria().withSchedulerObjectName(schedulerObjectName.toString())).withFilterQuery(filterQuery);
                triggersIndex.filter(triggers, (IIndexQueryCriteria)criteria);
            }
            this.setTriggerExecHealthIndicators(triggers);
            return QuartzTriggerMBeanTypeSupport.toCompositeDataArray(triggers);
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    public CompositeData getTrigger(String instanceId, String triggerName, String triggerGroupName, Locale locale) throws Exception {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            Trigger quartzTrigger = this.scheduler.getTrigger(ctx, triggerName, triggerGroupName);
            if (quartzTrigger == null) {
                return null;
            }
            Quartz2DomainTriggerConverter triggerConverter = new Quartz2DomainTriggerConverter(this.schedulerVersion);
            Object trigger = triggerConverter.convertTrigger(quartzTrigger, locale);
            this.setTriggerExecHealthIndicator((QuartzTrigger)trigger);
            return QuartzTriggerMBeanTypeSupport.toCompositeData(trigger);
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    public CompositeData[] getTriggersOfJob(String instanceId, String jobName, String jobGroupName, String filterQuery, Locale locale) throws Exception {
        List<QuartzTrigger> triggers = this.getTriggersOfJob(instanceId, jobName, jobGroupName, filterQuery, locale, true);
        return QuartzTriggerMBeanTypeSupport.toCompositeDataArray(triggers);
    }

    public CompositeData[] getTriggerNextFireTimes(String instanceId, String triggerName, String triggerGroupName, Integer maxFetchSize) throws Exception {
        return this.getTriggerFireTimes(instanceId, triggerName, triggerGroupName, new Date(), null, maxFetchSize);
    }

    public CompositeData[] getTriggerNextFireTimes(String instanceId, CompositeData compositeTrigger, Integer maxFetchSize) throws Exception {
        try {
            QuartzTrigger trigger = QuartzTriggerMBeanTypeSupport.fromCompositeData((CompositeData)compositeTrigger, (TimeZone)CommonConst.TIME_ZONE_UTC);
            Domain2QuartzTriggerConverter triggerConverter = new Domain2QuartzTriggerConverter(this.schedulerVersion);
            Object quartzTrigger = triggerConverter.convertTrigger(trigger);
            List<TimestampWithTZ> fireTimesList = this.getTriggerFireTimes((Trigger)quartzTrigger, new Date(), null, maxFetchSize);
            return TimestampWithTZMBeanTypeSupport.toCompositeDataArray(fireTimesList);
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    public CompositeData[] getTriggerFireTimes(String instanceId, String triggerName, String triggerGroupName, Date startTime, Date endTime, Integer maxFetchSize) throws Exception {
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            Trigger quartzTrigger = this.scheduler.getTrigger(ctx, triggerName, triggerGroupName);
            if (quartzTrigger == null) {
                throw new SchedulerException("Trigger " + triggerGroupName + '/' + triggerName + " not found.");
            }
            List<TimestampWithTZ> fireTimesList = this.getTriggerFireTimes(quartzTrigger, startTime, endTime, maxFetchSize);
            return TimestampWithTZMBeanTypeSupport.toCompositeDataArray(fireTimesList);
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    public Integer getJobCount(String instanceId) throws Exception {
        SchedulingContext ctx = new SchedulingContext(instanceId);
        int jobCount = 0;
        for (String jobGroupName : this.scheduler.getJobGroupNames(ctx)) {
            jobCount += this.scheduler.getJobNames(ctx, jobGroupName).length;
        }
        return jobCount;
    }

    public Integer getTriggerCount(String instanceId) throws Exception {
        SchedulingContext ctx = new SchedulingContext(instanceId);
        int triggerCount = 0;
        for (String triggerGroupName : this.scheduler.getTriggerGroupNames(ctx)) {
            triggerCount += this.scheduler.getTriggerNames(ctx, triggerGroupName).length;
        }
        return triggerCount;
    }

    public CompositeData[] getJobListeners(String instanceId) throws Exception {
        ArrayList<QuartzJobListener> jobListenerList = new ArrayList<QuartzJobListener>();
        for (JobListener quartzJobListener : this.scheduler.getGlobalJobListeners()) {
            jobListenerList.add(new QuartzJobListener().withName(quartzJobListener.getName()).withClassName(quartzJobListener.getClass().getName()));
        }
        for (String quartzJobListenerName : this.scheduler.getJobListenerNames()) {
            JobListener quartzJobListener = this.scheduler.getJobListener(quartzJobListenerName);
            jobListenerList.add(new QuartzJobListener().withName(quartzJobListener.getName()).withClassName(quartzJobListener.getClass().getName()));
        }
        return QuartzJobListenerMBeanTypeSupport.toCompositeDataArray(jobListenerList);
    }

    public CompositeData[] getTriggerListeners(String instanceId) throws Exception {
        ArrayList<QuartzTriggerListener> triggerListenerList = new ArrayList<QuartzTriggerListener>();
        for (TriggerListener quartzTriggerListener : this.scheduler.getGlobalTriggerListeners()) {
            triggerListenerList.add(new QuartzTriggerListener().withName(quartzTriggerListener.getName()).withClassName(quartzTriggerListener.getClass().getName()));
        }
        for (String quartzTriggerListenerName : this.scheduler.getTriggerListenerNames()) {
            TriggerListener quartzTriggerListener = this.scheduler.getTriggerListener(quartzTriggerListenerName);
            triggerListenerList.add(new QuartzTriggerListener().withName(quartzTriggerListener.getName()).withClassName(quartzTriggerListener.getClass().getName()));
        }
        return QuartzTriggerListenerMBeanTypeSupport.toCompositeDataArray(triggerListenerList);
    }

    public CompositeData[] getSchedulerListeners(String instanceId) throws Exception {
        ArrayList<QuartzSchedulerListener> schedulerListenerList = new ArrayList<QuartzSchedulerListener>();
        for (SchedulerListener quartzSchedulerListener : this.scheduler.getSchedulerListeners()) {
            schedulerListenerList.add(new QuartzSchedulerListener().withClassName(quartzSchedulerListener.getClass().getName()));
        }
        return QuartzSchedulerListenerMBeanTypeSupport.toCompositeDataArray(schedulerListenerList);
    }

    public String getClassLoaderInfo() throws Exception {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        RegisteredSchedulerInfo registeredSchedulerInfo = agent.getQuartzSchedulerRegistry().getSchedulerRegistration(schedulerObjectName);
        return registeredSchedulerInfo == null ? null : registeredSchedulerInfo.getSchedulerClassLoaderInfo();
    }

    public CompositeData[] getAvailableJobClasses() throws Exception {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        RegisteredSchedulerInfo registeredSchedulerInfo = agent.getQuartzSchedulerRegistry().getSchedulerRegistration(schedulerObjectName);
        List availableJobClassList = registeredSchedulerInfo.getSchedulerAvailableJobClass();
        return ClassDescMBeanTypeSupport.toCompositeDataArray((List)availableJobClassList);
    }

    public CompositeData getInitializedAt() throws Exception {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        RegisteredSchedulerInfo registeredSchedulerInfo = agent.getQuartzSchedulerRegistry().getSchedulerRegistration(schedulerObjectName);
        Calendar dateTime = registeredSchedulerInfo == null ? null : registeredSchedulerInfo.getSchedulerDateInitialized();
        return TimestampWithTZMBeanTypeSupport.fromCalendar2CompositeData((Calendar)dateTime);
    }

    public CompositeData getStartedAt() throws Exception {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        RegisteredSchedulerInfo registeredSchedulerInfo = agent.getQuartzSchedulerRegistry().getSchedulerRegistration(schedulerObjectName);
        Calendar dateTime = registeredSchedulerInfo == null ? null : registeredSchedulerInfo.getSchedulerDateStarted();
        return TimestampWithTZMBeanTypeSupport.fromCalendar2CompositeData((Calendar)dateTime);
    }

    public CompositeData getPausedAt() throws Exception {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        RegisteredSchedulerInfo registeredSchedulerInfo = agent.getQuartzSchedulerRegistry().getSchedulerRegistration(schedulerObjectName);
        Calendar dateTime = registeredSchedulerInfo == null ? null : registeredSchedulerInfo.getSchedulerDatePaused();
        return TimestampWithTZMBeanTypeSupport.fromCalendar2CompositeData((Calendar)dateTime);
    }

    public CompositeData getStoppedAt() throws Exception {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        RegisteredSchedulerInfo registeredSchedulerInfo = agent.getQuartzSchedulerRegistry().getSchedulerRegistration(schedulerObjectName);
        Calendar dateTime = registeredSchedulerInfo == null ? null : registeredSchedulerInfo.getSchedulerDateStopped();
        return TimestampWithTZMBeanTypeSupport.fromCalendar2CompositeData((Calendar)dateTime);
    }

    private List<QuartzJobDetail> getJobDetails(String instanceId, String filterJobGroupName, String filterQuery, boolean setNextFireTime, boolean setExecHealthIndicator) throws Exception {
        ArrayList<QuartzJobDetail> jobDetails = new ArrayList<QuartzJobDetail>();
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            Quartz2DomainJobDetailConverter jobDetailConverter = new Quartz2DomainJobDetailConverter(this.schedulerVersion);
            if (filterJobGroupName == null) {
                for (String jobGroupName : this.scheduler.getJobGroupNames(ctx)) {
                    for (String jobName : this.scheduler.getJobNames(ctx, jobGroupName)) {
                        JobDetail quartzJobDetail = this.scheduler.getJobDetail(ctx, jobName, jobGroupName);
                        if (quartzJobDetail == null) continue;
                        jobDetails.add(jobDetailConverter.convertJobDetail(quartzJobDetail));
                    }
                }
            } else {
                for (String jobName : this.scheduler.getJobNames(ctx, filterJobGroupName)) {
                    JobDetail quartzJobDetail = this.scheduler.getJobDetail(ctx, jobName, filterJobGroupName);
                    if (quartzJobDetail == null) continue;
                    jobDetails.add(jobDetailConverter.convertJobDetail(quartzJobDetail));
                }
            }
            if (filterQuery != null) {
                ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
                IAgent agent = Agent.getInstance();
                IIndex jobsIndex = agent.getQuartzJobIndex(schedulerObjectName);
                QuartzJobsQueryCriteria criteria = (QuartzJobsQueryCriteria)((QuartzJobsQueryCriteria)new QuartzJobsQueryCriteria().withSchedulerObjectName(schedulerObjectName.toString())).withJobGroupName(filterJobGroupName).withFilterQuery(filterQuery);
                jobsIndex.filter(jobDetails, (IIndexQueryCriteria)criteria);
            }
            if (setNextFireTime) {
                this.setJobNextFireTime(instanceId, jobDetails);
            }
            if (setExecHealthIndicator) {
                this.setJobExecHealthIndicators(instanceId, jobDetails);
            }
            return jobDetails;
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    private QuartzPlannedJobExecutions getPlannedJobExecutions0(String instanceId, Date startTime, Date endTime, String jobGroupName, String filterQuery, Integer maxFetchSize, Locale locale) throws Exception {
        boolean listWasCut = false;
        List<QuartzJobDetail> jobDetails = this.getJobDetails(instanceId, jobGroupName, filterQuery, false, true);
        QuartzPlannedJobExecutions plannedJobsExecutions = new QuartzPlannedJobExecutions();
        Domain2QuartzTriggerConverter triggerConverter = new Domain2QuartzTriggerConverter(this.schedulerVersion);
        for (QuartzJobDetail jobDetail : jobDetails) {
            List<QuartzTrigger> jobTriggers = this.getTriggersOfJob(instanceId, jobDetail.getName(), jobDetail.getGroup().getName(), null, locale, false);
            ArrayList<QuartzPlannedJobExecution> plannedExecutionsForJob = new ArrayList<QuartzPlannedJobExecution>();
            for (QuartzTrigger trigger : jobTriggers) {
                Object quartzTrigger = triggerConverter.convertTrigger(trigger);
                List<TimestampWithTZ> fireTimes = this.getTriggerFireTimes((Trigger)quartzTrigger, startTime, endTime, maxFetchSize);
                for (TimestampWithTZ fireTime : fireTimes) {
                    plannedExecutionsForJob.add(new QuartzPlannedJobExecution().withFireTime(fireTime.toCalendar()).withJobDetail(jobDetail).withTriggerGroupName(trigger.getGroup().getName()).withTriggerName(trigger.getName()).withTriggerJobDataMap(trigger.getJobDataMap()));
                }
            }
            listWasCut |= CommonUtils.addAndSortAndCut(plannedExecutionsForJob, Collections.emptyList(), PLANNED_JOB_EXECUTION_COMPARATOR, (int)maxFetchSize);
            listWasCut |= CommonUtils.addAndSortAndCut((List)plannedJobsExecutions.getExecution(), plannedExecutionsForJob, PLANNED_JOB_EXECUTION_COMPARATOR, (int)maxFetchSize);
        }
        plannedJobsExecutions.setComplete(Boolean.valueOf(!listWasCut));
        return plannedJobsExecutions;
    }

    private List<QuartzTrigger> getTriggersOfJob(String instanceId, String jobName, String jobGroupName, String filterQuery, Locale locale, boolean setExecHealthIndicators) throws Exception {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ArrayList<QuartzTrigger> triggers = new ArrayList<QuartzTrigger>();
        try {
            SchedulingContext ctx = new SchedulingContext(instanceId);
            Quartz2DomainTriggerConverter triggerConverter = new Quartz2DomainTriggerConverter(this.schedulerVersion);
            for (Trigger quartzTrigger : this.scheduler.getTriggersOfJob(ctx, jobName, jobGroupName)) {
                triggers.add((QuartzTrigger)triggerConverter.convertTrigger(quartzTrigger, locale));
            }
            if (filterQuery != null) {
                ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
                IAgent agent = Agent.getInstance();
                IIndex triggersIndex = agent.getQuartzTriggerIndex(schedulerObjectName);
                QuartzTriggersQueryCriteria criteria = (QuartzTriggersQueryCriteria)((QuartzTriggersQueryCriteria)new QuartzTriggersQueryCriteria().withSchedulerObjectName(schedulerObjectName.toString())).withFilterQuery(filterQuery);
                triggersIndex.filter(triggers, (IIndexQueryCriteria)criteria);
            }
            if (setExecHealthIndicators) {
                this.setTriggerExecHealthIndicators(triggers);
            }
            return triggers;
        }
        catch (SchedulerException e) {
            throw this.newPlainException(e);
        }
    }

    private List<TimestampWithTZ> getJobFireTimes(String instanceId, JobDetail quartzJobDetail, Date startTime, Date endTime, Integer maxFetchSize) throws Exception {
        if (maxFetchSize == 0) {
            return Collections.emptyList();
        }
        if (startTime == null) {
            startTime = new Date();
        }
        if (endTime == null) {
            endTime = new Date(Long.MAX_VALUE);
        }
        List<Object> fireTimesList = new ArrayList<TimestampWithTZ>(maxFetchSize);
        SchedulingContext ctx = new SchedulingContext(instanceId);
        for (Trigger quartzTrigger : this.scheduler.getTriggersOfJob(ctx, quartzJobDetail.getName(), quartzJobDetail.getGroup())) {
            List<TimestampWithTZ> triggerFireTimes = this.getTriggerFireTimes(quartzTrigger, startTime, endTime, maxFetchSize);
            fireTimesList.addAll(triggerFireTimes);
            Collections.sort(fireTimesList);
            fireTimesList = fireTimesList.subList(0, CommonUtils.min((int)fireTimesList.size(), (int)maxFetchSize));
        }
        return fireTimesList;
    }

    private List<TimestampWithTZ> getTriggerFireTimes(Trigger quartzTrigger, Date startTime, Date endTime, Integer maxFetchSize) {
        if (maxFetchSize == 0) {
            return Collections.emptyList();
        }
        if (startTime == null) {
            startTime = new Date();
        }
        if (endTime == null) {
            endTime = new Date(Long.MAX_VALUE);
        }
        TimeZone timeZone = TimeZone.getDefault();
        ArrayList<TimestampWithTZ> fireTimesList = new ArrayList<TimestampWithTZ>(maxFetchSize);
        Date nextFireTime = new Date(startTime.getTime() - 1L);
        while (fireTimesList.size() < maxFetchSize && !nextFireTime.after(endTime) && (nextFireTime = quartzTrigger.getFireTimeAfter(nextFireTime)) != null) {
            if (nextFireTime.after(endTime)) continue;
            fireTimesList.add(new TimestampWithTZ(nextFireTime.getTime(), timeZone));
        }
        return fireTimesList;
    }

    private void setJobNextFireTime(String instanceId, QuartzJobDetail jobDetail) throws Exception {
        this.setJobNextFireTime(instanceId, Collections.singletonList(jobDetail));
    }

    private void setJobNextFireTime(String instanceId, List<QuartzJobDetail> jobDetails) throws Exception {
        for (QuartzJobDetail jobDetail : jobDetails) {
            List<QuartzTrigger> jobTriggers = this.getTriggersOfJob(instanceId, jobDetail.getName(), jobDetail.getGroup().getName(), null, null, false);
            Calendar earliestFireTime = null;
            for (QuartzTrigger trigger : jobTriggers) {
                Calendar nextFireTime = trigger.getNextFireTime();
                if (nextFireTime == null) continue;
                if (earliestFireTime == null) {
                    earliestFireTime = nextFireTime;
                    continue;
                }
                if (earliestFireTime.compareTo(nextFireTime) <= 0) continue;
                earliestFireTime = nextFireTime;
            }
            jobDetail.setNextFireTime(earliestFireTime);
        }
    }

    private void setJobExecHealthIndicator(String instanceId, QuartzJobDetail jobDetail) {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        IQuartzExecHealthIndicators indicators = agent.getQuartzExecHealthIndicators(schedulerObjectName);
        jobDetail.setExecHealthIndicator(indicators.getJobIndicator(jobDetail.getGroup().getName(), jobDetail.getName()));
    }

    private void setJobExecHealthIndicators(String instanceId, List<QuartzJobDetail> jobDetails) {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        IQuartzExecHealthIndicators indicators = agent.getQuartzExecHealthIndicators(schedulerObjectName);
        for (QuartzJobDetail jobDetail : jobDetails) {
            jobDetail.setExecHealthIndicator(indicators.getJobIndicator(jobDetail.getGroup().getName(), jobDetail.getName()));
        }
    }

    private void setTriggerExecHealthIndicator(QuartzTrigger trigger) {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        IQuartzExecHealthIndicators indicators = agent.getQuartzExecHealthIndicators(schedulerObjectName);
        trigger.setExecHealthIndicator(indicators.getTriggerIndicator(trigger.getGroup().getName(), trigger.getName()));
    }

    private void setTriggerExecHealthIndicators(List<QuartzTrigger> triggers) {
        ObjectName schedulerObjectName = QuartzApiUtils.getSchedulerObjectName(this.scheduler);
        IAgent agent = Agent.getInstance();
        IQuartzExecHealthIndicators indicators = agent.getQuartzExecHealthIndicators(schedulerObjectName);
        for (QuartzTrigger trigger : triggers) {
            trigger.setExecHealthIndicator(indicators.getTriggerIndicator(trigger.getGroup().getName(), trigger.getName()));
        }
    }

    private Exception newPlainException(SchedulerException source) {
        Exception result = new Exception(source.getMessage());
        result.setStackTrace(source.getStackTrace());
        return result;
    }
}

