/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v1_8_x;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.IAgent;
import com.quartzdesk.agent.api.common.CommonConst;
import com.quartzdesk.agent.api.common.config.Configuration;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleInstanceIdGenerator;

public class StdSchedulerFactoryExtensions {
    private static final Logger log = LoggerFactory.getLogger(StdSchedulerFactoryExtensions.class);
    private static final String PROP_JOB_STORE_IS_CLUSTERED = "org.quartz.jobStore.isClustered";
    private SchedulerFactory schedulerFactory;

    public StdSchedulerFactoryExtensions(StdSchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
    }

    public Properties checkAndModifyConfigProperties(Properties props) {
        StringBuilder propsDump = new StringBuilder();
        TreeMap<Object, Object> sortedProps = new TreeMap<Object, Object>(props);
        for (Map.Entry entry : sortedProps.entrySet()) {
            propsDump.append(entry.getKey()).append('=').append(entry.getValue()).append(CommonConst.NL);
        }
        log.info("Initializing Quartz scheduler factory instance: {} with config properties: {}{}", new Object[]{this.schedulerFactory, CommonConst.NL, propsDump.toString().trim()});
        this.checkConfigProperties(props);
        return this.modifyConfigProperties(props);
    }

    private void checkConfigProperties(Properties props) {
        String jmxObjectName = props.getProperty("org.quartz.scheduler.jmx.objectName");
        String instanceId = props.getProperty("org.quartz.scheduler.instanceId");
        String instanceIdGeneratorClass = props.getProperty("org.quartz.scheduler.instanceIdGenerator.class");
        Boolean jobStoreIsClustered = false;
        String jobStoreIsClusteredStr = props.getProperty(PROP_JOB_STORE_IS_CLUSTERED);
        if (jobStoreIsClusteredStr != null) {
            jobStoreIsClustered = Boolean.parseBoolean(jobStoreIsClusteredStr);
        }
        if (jmxObjectName == null && jobStoreIsClustered.booleanValue() && (instanceId == null || "AUTO".equals(instanceId))) {
            if (instanceIdGeneratorClass == null) {
                log.warn("Quartz scheduler factory {} is not configured to use particular ID generator and defaults to using {}. This default instance ID generator causes the Quartz scheduler JMX object name to change upon every Quartz scheduler restart. QuartzDesk requires the Quartz scheduler JMX object name to remain constant over time. For details, please refer to https://www.quartzdesk.com/support/faqs?tag=quartz-scheduler-mbean-name.", (Object)this.schedulerFactory, (Object)SimpleInstanceIdGenerator.class.getName());
            } else if (SimpleInstanceIdGenerator.class.getName().equals(instanceIdGeneratorClass)) {
                log.warn("Quartz scheduler factory {} is configured to use {}. This instance ID generator causes the Quartz scheduler JMX object name to change upon every Quartz scheduler restart. QuartzDesk requires the Quartz scheduler JMX object name to remain constant over time. For details, please refer to https://www.quartzdesk.com/support/faqs?tag=quartz-scheduler-mbean-name.", (Object)this.schedulerFactory, (Object)SimpleInstanceIdGenerator.class.getName());
            }
        }
    }

    private Properties modifyConfigProperties(Properties props) {
        Properties newProps = new Properties(props);
        String jmxExportStr = props.getProperty("org.quartz.scheduler.jmx.export");
        if (jmxExportStr == null) {
            IAgent agent = Agent.getInstance();
            Configuration config = agent.getConfiguration();
            if (config.getBoolean("quartz.scheduler.autoJmxExport").booleanValue()) {
                log.info("Setting Quartz configuration property: {} to: {}", (Object)"org.quartz.scheduler.jmx.export", (Object)true);
                newProps.setProperty("org.quartz.scheduler.jmx.export", Boolean.TRUE.toString());
            } else {
                log.info("Skipped setting of Quartz configuration property: {} because {} QuartzDesk JVM Agent config property is set to false.", (Object)"org.quartz.scheduler.jmx.export", (Object)"quartz.scheduler.autoJmxExport");
            }
        } else {
            log.debug("Skipped setting of Quartz configuration property: {} because it is already set (value: {}).", (Object)"org.quartz.scheduler.jmx.export", (Object)jmxExportStr);
        }
        return newProps;
    }
}

