/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.jmx;

import com.quartzdesk.agent.api.common.text.DateTimeUtils;
import com.quartzdesk.agent.api.domain.model.common.DayTime;
import com.quartzdesk.agent.api.domain.model.common.Version;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendar;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCronTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzDateIntervalTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzIntervalType;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMap;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMapEntry;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzNthIncludedDayTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzRepeatIntervalUnit;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzSimpleTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTrigger;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Calendar;
import java.util.TimeZone;
import org.quartz.CronTrigger;
import org.quartz.DateIntervalTrigger;
import org.quartz.JobDataMap;
import org.quartz.NthIncludedDayTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class Domain2QuartzTriggerConverter {
    private static final Logger log = LoggerFactory.getLogger(Domain2QuartzTriggerConverter.class);
    private Version schedulerVersion;

    public Domain2QuartzTriggerConverter(Version schedulerVersion) {
        this.schedulerVersion = schedulerVersion;
    }

    public <T extends QuartzTrigger, Q extends Trigger> Q convertTrigger(T trigger) throws Exception {
        if (trigger instanceof QuartzSimpleTrigger) {
            return (Q)this.convertSimpleTrigger((QuartzSimpleTrigger)trigger);
        }
        if (trigger instanceof QuartzCronTrigger) {
            return (Q)this.convertCronTrigger((QuartzCronTrigger)trigger);
        }
        if (trigger instanceof QuartzDateIntervalTrigger) {
            return (Q)this.convertDateIntervalTrigger((QuartzDateIntervalTrigger)trigger);
        }
        if (trigger instanceof QuartzNthIncludedDayTrigger) {
            return (Q)this.convertNthIncludedDayTrigger((QuartzNthIncludedDayTrigger)trigger);
        }
        throw new RuntimeException("Unexpected domain trigger type: " + trigger);
    }

    private SimpleTrigger convertSimpleTrigger(QuartzSimpleTrigger trigger) {
        SimpleTrigger quartzTrigger = this.populateCommonTriggerAttributes(new SimpleTrigger(), trigger);
        quartzTrigger.setRepeatCount(trigger.getRepeatCount().intValue());
        quartzTrigger.setRepeatInterval(trigger.getRepeatInterval().longValue());
        return quartzTrigger;
    }

    private CronTrigger convertCronTrigger(QuartzCronTrigger trigger) throws Exception {
        CronTrigger quartzTrigger = this.populateCommonTriggerAttributes(new CronTrigger(), trigger);
        quartzTrigger.setCronExpression(trigger.getCronExpression());
        quartzTrigger.setTimeZone(this.convertTimeZone(trigger.getTimeZone()));
        return quartzTrigger;
    }

    private DateIntervalTrigger convertDateIntervalTrigger(QuartzDateIntervalTrigger trigger) {
        DateIntervalTrigger quartzTrigger = this.populateCommonTriggerAttributes(new DateIntervalTrigger(), trigger);
        quartzTrigger.setRepeatIntervalUnit(this.convertIntervalUnit(trigger.getRepeatIntervalUnit()));
        quartzTrigger.setRepeatInterval(trigger.getRepeatInterval().intValue());
        return quartzTrigger;
    }

    private NthIncludedDayTrigger convertNthIncludedDayTrigger(QuartzNthIncludedDayTrigger trigger) {
        NthIncludedDayTrigger quartzTrigger = this.populateCommonTriggerAttributes(new NthIncludedDayTrigger(), trigger);
        quartzTrigger.setN(trigger.getNthDay().intValue());
        quartzTrigger.setIntervalType(this.convertIntervalType(trigger.getIntervalType()));
        quartzTrigger.setFireAtTime(this.convertTimeOfDay(trigger.getFireAt()));
        quartzTrigger.setTimeZone(this.convertTimeZone(trigger.getTimeZone()));
        quartzTrigger.setNextFireCutoffInterval(trigger.getNextFireCutoffInterval().intValue());
        return quartzTrigger;
    }

    private <T extends QuartzTrigger, Q extends Trigger> Q populateCommonTriggerAttributes(Q quartzTrigger, T trigger) {
        quartzTrigger.setName(trigger.getName());
        quartzTrigger.setGroup(trigger.getGroup().getName());
        quartzTrigger.setJobName(trigger.getJobName());
        quartzTrigger.setJobGroup(trigger.getJobGroup().getName());
        quartzTrigger.setCalendarName(this.convertCalendar(trigger.getCalendar()));
        quartzTrigger.setDescription(trigger.getDescription());
        quartzTrigger.setPriority(trigger.getPriority().intValue());
        quartzTrigger.setMisfireInstruction(trigger.getMisfireInstruction().intValue());
        quartzTrigger.setStartTime(DateTimeUtils.calendar2Date((Calendar)trigger.getStartTime()));
        quartzTrigger.setEndTime(DateTimeUtils.calendar2Date((Calendar)trigger.getEndTime()));
        quartzTrigger.setJobDataMap(this.convertJobDataMap(trigger.getJobDataMap()));
        return quartzTrigger;
    }

    private int convertIntervalType(QuartzIntervalType intervalType) {
        switch (intervalType) {
            case WEEKLY: {
                return 3;
            }
            case MONTHLY: {
                return 1;
            }
            case YEARLY: {
                return 2;
            }
        }
        throw new RuntimeException("Unexpected interval type value: " + intervalType);
    }

    private DateIntervalTrigger.IntervalUnit convertIntervalUnit(QuartzRepeatIntervalUnit intervalUnit) {
        return intervalUnit == null ? null : DateIntervalTrigger.IntervalUnit.valueOf((String)intervalUnit.name());
    }

    private String convertTimeOfDay(DayTime dayTime) {
        if (dayTime == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (dayTime.getHours() < 10) {
            result.append('0');
        }
        result.append(dayTime.getHours());
        result.append(':');
        if (dayTime.getMinutes() < 10) {
            result.append('0');
        }
        result.append(dayTime.getMinutes());
        result.append(':');
        if (dayTime.getSeconds() < 10) {
            result.append('0');
        }
        result.append(dayTime.getSeconds());
        return result.toString();
    }

    private JobDataMap convertJobDataMap(QuartzJobDataMap jobDataMap) {
        if (jobDataMap == null) {
            return null;
        }
        JobDataMap quartzJobDataMap = new JobDataMap();
        for (QuartzJobDataMapEntry entry : jobDataMap.getEntry()) {
            quartzJobDataMap.put(entry.getName(), entry.getValue());
        }
        return quartzJobDataMap;
    }

    private String convertCalendar(QuartzCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.getId();
    }

    private TimeZone convertTimeZone(com.quartzdesk.agent.api.domain.model.common.TimeZone timeZone) {
        if (timeZone == null) {
            return null;
        }
        return TimeZone.getTimeZone(timeZone.getId());
    }
}

