/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.jmx;

import com.quartzdesk.agent.api.common.CommonUtils;
import com.quartzdesk.agent.api.domain.model.common.Version;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMap;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMapEntry;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDetail;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobGroup;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

public class Quartz2DomainJobDetailConverter {
    private static final Logger log = LoggerFactory.getLogger(Quartz2DomainJobDetailConverter.class);
    private Version schedulerVersion;

    public Quartz2DomainJobDetailConverter(Version schedulerVersion) {
        this.schedulerVersion = schedulerVersion;
    }

    public QuartzJobDetail convertJobDetail(JobDetail quartzJobDetail) {
        return new QuartzJobDetail().withGroup(new QuartzJobGroup().withName(quartzJobDetail.getKey().getGroup())).withName(quartzJobDetail.getKey().getName()).withDescription(quartzJobDetail.getDescription()).withJobClass(quartzJobDetail.getJobClass().getName()).withDurability(Boolean.valueOf(quartzJobDetail.isDurable())).withShouldRecover(Boolean.valueOf(quartzJobDetail.requestsRecovery())).withVolatility(Boolean.valueOf(quartzJobDetail.isVolatile())).withJobDataMap(this.convertJobDataMap(quartzJobDetail.getJobDataMap())).withConcurrentExecutionDisallowed(Boolean.valueOf(quartzJobDetail.isStateful())).withPersistJobDataAfterExecution(Boolean.valueOf(quartzJobDetail.isStateful()));
    }

    private QuartzJobDataMap convertJobDataMap(JobDataMap quartzJobDataMap) {
        if (quartzJobDataMap == null) {
            return null;
        }
        QuartzJobDataMap jobDataMap = new QuartzJobDataMap();
        for (Map.Entry entry : quartzJobDataMap.entrySet()) {
            jobDataMap.getEntry().add(new QuartzJobDataMapEntry().withName((String)entry.getKey()).withValue(CommonUtils.safeToString(entry.getValue())));
        }
        return jobDataMap;
    }
}

