/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.jmx;

import com.quartzdesk.agent.api.common.CommonConst;
import com.quartzdesk.agent.api.common.CommonUtils;
import com.quartzdesk.agent.api.common.text.DateTimeUtils;
import com.quartzdesk.agent.api.domain.model.common.DayTime;
import com.quartzdesk.agent.api.domain.model.common.Version;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendar;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCronTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzDateIntervalTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzIntervalType;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMap;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMapEntry;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobGroup;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzNthIncludedDayTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzRepeatIntervalUnit;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzSimpleTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTriggerGroup;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronTrigger;
import org.quartz.DateIntervalTrigger;
import org.quartz.JobDataMap;
import org.quartz.NthIncludedDayTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class Quartz2DomainTriggerConverter {
    private static final Logger log = LoggerFactory.getLogger(Quartz2DomainTriggerConverter.class);
    private Version schedulerVersion;

    public Quartz2DomainTriggerConverter(Version schedulerVersion) {
        this.schedulerVersion = schedulerVersion;
    }

    public <T extends QuartzTrigger> T convertTrigger(Trigger quartzTrigger, Locale locale) {
        if (quartzTrigger instanceof SimpleTrigger) {
            return (T)this.convertSimpleTrigger((SimpleTrigger)quartzTrigger, locale);
        }
        if (quartzTrigger instanceof CronTrigger) {
            return (T)this.convertCronTrigger((CronTrigger)quartzTrigger, locale);
        }
        if (quartzTrigger instanceof DateIntervalTrigger) {
            return (T)this.convertDateIntervalTrigger((DateIntervalTrigger)quartzTrigger, locale);
        }
        if (quartzTrigger instanceof NthIncludedDayTrigger) {
            return (T)this.convertNthIncludedDayTrigger((NthIncludedDayTrigger)quartzTrigger, locale);
        }
        throw new RuntimeException("Unexpected Quartz trigger type: " + quartzTrigger);
    }

    private QuartzSimpleTrigger convertSimpleTrigger(SimpleTrigger quartzTrigger, Locale locale) {
        QuartzSimpleTrigger trigger = this.populateCommonTriggerAttributes(new QuartzSimpleTrigger(), quartzTrigger, locale);
        trigger.withRepeatCount(Integer.valueOf(quartzTrigger.getRepeatCount())).withRepeatInterval(Long.valueOf(quartzTrigger.getRepeatInterval()));
        return trigger;
    }

    private QuartzCronTrigger convertCronTrigger(CronTrigger quartzTrigger, Locale locale) {
        QuartzCronTrigger trigger = this.populateCommonTriggerAttributes(new QuartzCronTrigger(), quartzTrigger, locale);
        trigger.withCronExpression(quartzTrigger.getCronExpression()).withTimeZone(this.convertTimeZone(quartzTrigger.getTimeZone(), locale));
        return trigger;
    }

    private QuartzDateIntervalTrigger convertDateIntervalTrigger(DateIntervalTrigger quartzTrigger, Locale locale) {
        QuartzDateIntervalTrigger trigger = this.populateCommonTriggerAttributes(new QuartzDateIntervalTrigger(), quartzTrigger, locale);
        trigger.withRepeatIntervalUnit(this.convertIntervalUnit(quartzTrigger.getRepeatIntervalUnit())).withRepeatInterval(Integer.valueOf(quartzTrigger.getRepeatInterval()));
        return trigger;
    }

    private QuartzNthIncludedDayTrigger convertNthIncludedDayTrigger(NthIncludedDayTrigger quartzTrigger, Locale locale) {
        QuartzNthIncludedDayTrigger trigger = this.populateCommonTriggerAttributes(new QuartzNthIncludedDayTrigger(), quartzTrigger, locale);
        trigger.withNthDay(Integer.valueOf(quartzTrigger.getN())).withIntervalType(this.convertIntervalType(quartzTrigger.getIntervalType())).withFireAt(this.convertTimeOfDay(quartzTrigger.getFireAtTime())).withTimeZone(this.convertTimeZone(quartzTrigger.getTimeZone(), locale)).withNextFireCutoffInterval(Integer.valueOf(quartzTrigger.getNextFireCutoffInterval()));
        return trigger;
    }

    private <T extends QuartzTrigger, Q extends Trigger> T populateCommonTriggerAttributes(T trigger, Q quartzTrigger, Locale locale) {
        trigger.withName(quartzTrigger.getKey().getName()).withGroup(new QuartzTriggerGroup().withName(quartzTrigger.getKey().getGroup())).withJobName(quartzTrigger.getJobName()).withJobGroup(new QuartzJobGroup().withName(quartzTrigger.getJobGroup())).withCalendar(this.convertCalendar(quartzTrigger.getCalendarName())).withDescription(quartzTrigger.getDescription()).withPriority(Integer.valueOf(quartzTrigger.getPriority())).withMisfireInstruction(Integer.valueOf(quartzTrigger.getMisfireInstruction())).withStartTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getStartTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withEndTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getEndTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withPreviousFireTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getPreviousFireTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withNextFireTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getNextFireTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withFinalFireTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getFinalFireTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withJobDataMap(this.convertJobDataMap(quartzTrigger.getJobDataMap()));
        return trigger;
    }

    private QuartzIntervalType convertIntervalType(int intervalType) {
        switch (intervalType) {
            case 3: {
                return QuartzIntervalType.WEEKLY;
            }
            case 1: {
                return QuartzIntervalType.MONTHLY;
            }
            case 2: {
                return QuartzIntervalType.YEARLY;
            }
        }
        throw new RuntimeException("Unexpected interval type value: " + intervalType);
    }

    private QuartzRepeatIntervalUnit convertIntervalUnit(DateIntervalTrigger.IntervalUnit intervalUnit) {
        return intervalUnit == null ? null : QuartzRepeatIntervalUnit.valueOf((String)intervalUnit.name());
    }

    private DayTime convertTimeOfDay(String quartzTimeOfDay) {
        if (quartzTimeOfDay == null) {
            return null;
        }
        String[] strComps = quartzTimeOfDay.split(":");
        if (strComps.length != 3) {
            throw new RuntimeException("Unexpected number of " + DayTime.class.getSimpleName() + " components: " + strComps.length + " in string: " + quartzTimeOfDay);
        }
        return new DayTime().withHours(Integer.valueOf(Integer.parseInt(strComps[0]))).withMinutes(Integer.valueOf(Integer.parseInt(strComps[1]))).withSeconds(Integer.valueOf(Integer.parseInt(strComps[2])));
    }

    private QuartzJobDataMap convertJobDataMap(JobDataMap quartzJobDataMap) {
        if (quartzJobDataMap == null) {
            return null;
        }
        QuartzJobDataMap jobDataMap = new QuartzJobDataMap();
        for (Map.Entry entry : quartzJobDataMap.entrySet()) {
            jobDataMap.getEntry().add(new QuartzJobDataMapEntry().withName((String)entry.getKey()).withValue(CommonUtils.safeToString(entry.getValue())));
        }
        return jobDataMap;
    }

    private QuartzCalendar convertCalendar(String quartzCalendarName) {
        if (quartzCalendarName == null) {
            return null;
        }
        return new QuartzCalendar().withId(quartzCalendarName).withDisplayName(quartzCalendarName);
    }

    private com.quartzdesk.agent.api.domain.model.common.TimeZone convertTimeZone(TimeZone quartzTimeZone, Locale locale) {
        if (quartzTimeZone == null) {
            return null;
        }
        return new com.quartzdesk.agent.api.domain.model.common.TimeZone().withId(quartzTimeZone.getID()).withDisplayName(DateTimeUtils.formatTimeZone((TimeZone)quartzTimeZone, (Locale)locale)).withOffset(Integer.valueOf(quartzTimeZone.getRawOffset() / 1000));
    }
}

