/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.listener;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.IAgent;
import com.quartzdesk.agent.api.common.text.DateTimeUtils;
import com.quartzdesk.agent.api.domain.model.scheduler.SchedulerType;
import com.quartzdesk.agent.api.scheduler.common.ISchedulingEvent;
import com.quartzdesk.agent.api.scheduler.common.ISchedulingEventInterceptor;
import com.quartzdesk.agent.api.scheduler.quartz.QuartzEvent;
import com.quartzdesk.agent.api.scheduler.quartz.trigger.QuartzTriggerMisfiredEvent;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.QuartzApiUtils;
import com.quartzdesk.api.agent.scheduler.quartz.v1_8_x.listener.QuartzJobListener;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Date;
import javax.management.ObjectName;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.core.QuartzScheduler;

public class QuartzTriggerListener
implements TriggerListener {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobListener.class);
    private QuartzScheduler quartzScheduler;
    private ObjectName schedObjectName;
    private ISchedulingEventInterceptor<QuartzEvent> schedulingEventInterceptor;

    public QuartzTriggerListener(QuartzScheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
        this.schedObjectName = QuartzApiUtils.getSchedulerObjectName(quartzScheduler);
        IAgent agent = Agent.getInstance();
        this.schedulingEventInterceptor = agent.getSchedulingEventInterceptor(SchedulerType.QUARTZ);
    }

    public String getName() {
        return "QuartzDeskTriggerListener";
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        return false;
    }

    public void triggerMisfired(Trigger trigger) {
        log.debug("Invoked triggerMisfired callback method in Quartz trigger listener: {}, trigger: {}", (Object)this, (Object)trigger);
        try {
            QuartzTriggerMisfiredEvent event = QuartzApiUtils.prepareEvent(QuartzTriggerMisfiredEvent.class, this.quartzScheduler);
            event.setMissedFireTime(DateTimeUtils.date2Calendar((Date)trigger.getNextFireTime()));
            event.setTriggerGroupName(trigger.getKey().getGroup());
            event.setTriggerName(trigger.getKey().getName());
            event.setTriggerType(QuartzApiUtils.getTriggerType(trigger));
            event.setTriggerMisfireInstruction(Integer.valueOf(trigger.getMisfireInstruction()));
            event.setTriggerJobDataMap(QuartzApiUtils.toEventJobDataMap(trigger.getJobDataMap()));
            event.setJobGroupName(trigger.getJobGroup());
            event.setJobName(trigger.getJobName());
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in triggerMisfired callback method of Quartz trigger listener: " + this, e);
        }
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode) {
    }
}

