/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v2_0_x.jmx;

import com.quartzdesk.agent.api.common.text.DateTimeUtils;
import com.quartzdesk.agent.api.domain.model.common.Version;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendar;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendarIntervalTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCronTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMap;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMapEntry;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzRepeatIntervalUnit;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzSimpleTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTrigger;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Calendar;
import java.util.TimeZone;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.CronTrigger;
import org.quartz.DateBuilder;
import org.quartz.JobDataMap;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class Domain2QuartzTriggerConverter {
    private static final Logger log = LoggerFactory.getLogger(Domain2QuartzTriggerConverter.class);
    private Version schedulerVersion;

    public Domain2QuartzTriggerConverter(Version schedulerVersion) {
        this.schedulerVersion = schedulerVersion;
    }

    public <T extends QuartzTrigger, Q extends Trigger> Q convertTrigger(T trigger) throws Exception {
        if (trigger instanceof QuartzSimpleTrigger) {
            return (Q)this.convertSimpleTrigger((QuartzSimpleTrigger)trigger);
        }
        if (trigger instanceof QuartzCronTrigger) {
            return (Q)this.convertCronTrigger((QuartzCronTrigger)trigger);
        }
        if (trigger instanceof QuartzCalendarIntervalTrigger) {
            return (Q)this.convertCalendarIntervalTrigger((QuartzCalendarIntervalTrigger)trigger);
        }
        throw new RuntimeException("Unexpected domain trigger type: " + trigger);
    }

    private SimpleTrigger convertSimpleTrigger(QuartzSimpleTrigger trigger) throws Exception {
        SimpleTriggerImpl quartzTrigger = this.populateCommonTriggerAttributes(new SimpleTriggerImpl(), trigger);
        quartzTrigger.setRepeatCount(trigger.getRepeatCount().intValue());
        quartzTrigger.setRepeatInterval(trigger.getRepeatInterval().longValue());
        return quartzTrigger;
    }

    private CronTrigger convertCronTrigger(QuartzCronTrigger trigger) throws Exception {
        CronTriggerImpl quartzTrigger = this.populateCommonTriggerAttributes(new CronTriggerImpl(), trigger);
        quartzTrigger.setCronExpression(trigger.getCronExpression());
        quartzTrigger.setTimeZone(this.convertTimeZone(trigger.getTimeZone()));
        return quartzTrigger;
    }

    private CalendarIntervalTrigger convertCalendarIntervalTrigger(QuartzCalendarIntervalTrigger trigger) {
        CalendarIntervalTriggerImpl quartzTrigger = this.populateCommonTriggerAttributes(new CalendarIntervalTriggerImpl(), trigger);
        quartzTrigger.setRepeatIntervalUnit(this.convertIntervalUnit(trigger.getRepeatIntervalUnit()));
        quartzTrigger.setRepeatInterval(trigger.getRepeatInterval().intValue());
        return quartzTrigger;
    }

    private <T extends QuartzTrigger, Q extends AbstractTrigger<?>> Q populateCommonTriggerAttributes(Q quartzTrigger, T trigger) {
        quartzTrigger.setName(trigger.getName());
        quartzTrigger.setGroup(trigger.getGroup().getName());
        quartzTrigger.setJobName(trigger.getJobName());
        quartzTrigger.setJobGroup(trigger.getJobGroup().getName());
        quartzTrigger.setCalendarName(this.convertCalendar(trigger.getCalendar()));
        quartzTrigger.setDescription(trigger.getDescription());
        quartzTrigger.setPriority(trigger.getPriority().intValue());
        quartzTrigger.setMisfireInstruction(trigger.getMisfireInstruction().intValue());
        quartzTrigger.setStartTime(DateTimeUtils.calendar2Date((Calendar)trigger.getStartTime()));
        quartzTrigger.setEndTime(DateTimeUtils.calendar2Date((Calendar)trigger.getEndTime()));
        quartzTrigger.setJobDataMap(this.convertJobDataMap(trigger.getJobDataMap()));
        return quartzTrigger;
    }

    private DateBuilder.IntervalUnit convertIntervalUnit(QuartzRepeatIntervalUnit intervalUnit) {
        return intervalUnit == null ? null : DateBuilder.IntervalUnit.valueOf((String)intervalUnit.name());
    }

    private JobDataMap convertJobDataMap(QuartzJobDataMap jobDataMap) {
        if (jobDataMap == null) {
            return null;
        }
        JobDataMap quartzJobDataMap = new JobDataMap();
        for (QuartzJobDataMapEntry entry : jobDataMap.getEntry()) {
            quartzJobDataMap.put(entry.getName(), entry.getValue());
        }
        return quartzJobDataMap;
    }

    private String convertCalendar(QuartzCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.getId();
    }

    private TimeZone convertTimeZone(com.quartzdesk.agent.api.domain.model.common.TimeZone timeZone) {
        if (timeZone == null) {
            return null;
        }
        return TimeZone.getTimeZone(timeZone.getId());
    }
}

