/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v2_1_x.jmx;

import com.quartzdesk.agent.api.common.text.DateTimeUtils;
import com.quartzdesk.agent.api.domain.model.common.DayTime;
import com.quartzdesk.agent.api.domain.model.common.Version;
import com.quartzdesk.agent.api.domain.model.common.Weekday;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendar;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendarIntervalTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCronTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzDailyTimeIntervalTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMap;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMapEntry;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzRepeatIntervalUnit;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzSimpleTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTrigger;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.CronTrigger;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.JobDataMap;
import org.quartz.SimpleTrigger;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class Domain2QuartzTriggerConverter {
    private static final Logger log = LoggerFactory.getLogger(Domain2QuartzTriggerConverter.class);
    private Version schedulerVersion;

    public Domain2QuartzTriggerConverter(Version schedulerVersion) {
        this.schedulerVersion = schedulerVersion;
    }

    public <T extends QuartzTrigger, Q extends Trigger> Q convertTrigger(T trigger) throws Exception {
        if (trigger instanceof QuartzSimpleTrigger) {
            return (Q)this.convertSimpleTrigger((QuartzSimpleTrigger)trigger);
        }
        if (trigger instanceof QuartzCronTrigger) {
            return (Q)this.convertCronTrigger((QuartzCronTrigger)trigger);
        }
        if (trigger instanceof QuartzCalendarIntervalTrigger) {
            return (Q)this.convertCalendarIntervalTrigger((QuartzCalendarIntervalTrigger)trigger);
        }
        if (trigger instanceof QuartzDailyTimeIntervalTrigger) {
            return (Q)this.convertDailyTimeIntervalTrigger((QuartzDailyTimeIntervalTrigger)trigger);
        }
        throw new RuntimeException("Unexpected domain trigger type: " + trigger);
    }

    private SimpleTrigger convertSimpleTrigger(QuartzSimpleTrigger trigger) throws Exception {
        SimpleTriggerImpl quartzTrigger = this.populateCommonTriggerAttributes(new SimpleTriggerImpl(), trigger);
        quartzTrigger.setRepeatCount(trigger.getRepeatCount().intValue());
        quartzTrigger.setRepeatInterval(trigger.getRepeatInterval().longValue());
        return quartzTrigger;
    }

    private CronTrigger convertCronTrigger(QuartzCronTrigger trigger) throws Exception {
        CronTriggerImpl quartzTrigger = this.populateCommonTriggerAttributes(new CronTriggerImpl(), trigger);
        quartzTrigger.setCronExpression(trigger.getCronExpression());
        quartzTrigger.setTimeZone(this.convertTimeZone(trigger.getTimeZone()));
        return quartzTrigger;
    }

    private CalendarIntervalTrigger convertCalendarIntervalTrigger(QuartzCalendarIntervalTrigger trigger) {
        CalendarIntervalTriggerImpl quartzTrigger = this.populateCommonTriggerAttributes(new CalendarIntervalTriggerImpl(), trigger);
        quartzTrigger.setRepeatIntervalUnit(this.convertIntervalUnit(trigger.getRepeatIntervalUnit()));
        quartzTrigger.setRepeatInterval(trigger.getRepeatInterval().intValue());
        if (this.schedulerVersion.getMaintenance() >= 3) {
            quartzTrigger.setTimeZone(this.convertTimeZone(trigger.getTimeZone()));
            quartzTrigger.setPreserveHourOfDayAcrossDaylightSavings(trigger.isPreserveHourOfDayAcrossDaylightSavings().booleanValue());
            quartzTrigger.setSkipDayIfHourDoesNotExist(trigger.isSkipDayIfHourDoesNotExist().booleanValue());
        }
        return quartzTrigger;
    }

    private DailyTimeIntervalTrigger convertDailyTimeIntervalTrigger(QuartzDailyTimeIntervalTrigger trigger) {
        DailyTimeIntervalTriggerImpl quartzTrigger = this.populateCommonTriggerAttributes(new DailyTimeIntervalTriggerImpl(), trigger);
        quartzTrigger.setRepeatIntervalUnit(this.convertIntervalUnit(trigger.getRepeatIntervalUnit()));
        quartzTrigger.setRepeatCount(trigger.getRepeatCount().intValue());
        quartzTrigger.setRepeatInterval(trigger.getRepeatInterval().intValue());
        quartzTrigger.setStartTimeOfDay(this.convertTimeOfDay(trigger.getStartTimeOfDay()));
        quartzTrigger.setEndTimeOfDay(this.convertTimeOfDay(trigger.getEndTimeOfDay()));
        quartzTrigger.setDaysOfWeek(this.convertDaysOfWeek(trigger.getDaysOfWeek()));
        return quartzTrigger;
    }

    private <T extends QuartzTrigger, Q extends AbstractTrigger<?>> Q populateCommonTriggerAttributes(Q quartzTrigger, T trigger) {
        quartzTrigger.setName(trigger.getName());
        quartzTrigger.setGroup(trigger.getGroup().getName());
        quartzTrigger.setJobName(trigger.getJobName());
        quartzTrigger.setJobGroup(trigger.getJobGroup().getName());
        quartzTrigger.setCalendarName(this.convertCalendar(trigger.getCalendar()));
        quartzTrigger.setDescription(trigger.getDescription());
        quartzTrigger.setPriority(trigger.getPriority().intValue());
        quartzTrigger.setMisfireInstruction(trigger.getMisfireInstruction().intValue());
        quartzTrigger.setStartTime(DateTimeUtils.calendar2Date((Calendar)trigger.getStartTime()));
        quartzTrigger.setEndTime(DateTimeUtils.calendar2Date((Calendar)trigger.getEndTime()));
        quartzTrigger.setJobDataMap(this.convertJobDataMap(trigger.getJobDataMap()));
        return quartzTrigger;
    }

    private DateBuilder.IntervalUnit convertIntervalUnit(QuartzRepeatIntervalUnit intervalUnit) {
        return intervalUnit == null ? null : DateBuilder.IntervalUnit.valueOf((String)intervalUnit.name());
    }

    private TimeOfDay convertTimeOfDay(DayTime dayTime) {
        return dayTime == null ? null : new TimeOfDay(dayTime.getHours().intValue(), dayTime.getMinutes().intValue(), dayTime.getSeconds().intValue());
    }

    private Set<Integer> convertDaysOfWeek(Collection<Weekday> daysOfWeek) {
        if (daysOfWeek == null) {
            return null;
        }
        HashSet<Integer> weekdays = new HashSet<Integer>();
        block9: for (Weekday dayOfWeek : daysOfWeek) {
            switch (dayOfWeek) {
                case MONDAY: {
                    weekdays.add(2);
                    continue block9;
                }
                case TUESDAY: {
                    weekdays.add(3);
                    continue block9;
                }
                case WEDNESDAY: {
                    weekdays.add(4);
                    continue block9;
                }
                case THURSDAY: {
                    weekdays.add(5);
                    continue block9;
                }
                case FRIDAY: {
                    weekdays.add(6);
                    continue block9;
                }
                case SATURDAY: {
                    weekdays.add(7);
                    continue block9;
                }
                case SUNDAY: {
                    weekdays.add(1);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unexpected day of week value: " + dayOfWeek);
        }
        return weekdays;
    }

    private JobDataMap convertJobDataMap(QuartzJobDataMap jobDataMap) {
        if (jobDataMap == null) {
            return null;
        }
        JobDataMap quartzJobDataMap = new JobDataMap();
        for (QuartzJobDataMapEntry entry : jobDataMap.getEntry()) {
            quartzJobDataMap.put(entry.getName(), entry.getValue());
        }
        return quartzJobDataMap;
    }

    private String convertCalendar(QuartzCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.getId();
    }

    private TimeZone convertTimeZone(com.quartzdesk.agent.api.domain.model.common.TimeZone timeZone) {
        if (timeZone == null) {
            return null;
        }
        return TimeZone.getTimeZone(timeZone.getId());
    }
}

