/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v2_1_x.listener;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.api.domain.model.scheduler.SchedulerType;
import com.quartzdesk.agent.api.scheduler.common.ISchedulingEvent;
import com.quartzdesk.agent.api.scheduler.common.ISchedulingEventInterceptor;
import com.quartzdesk.agent.api.scheduler.quartz.QuartzEvent;
import com.quartzdesk.agent.api.scheduler.quartz.job.QuartzJobAddedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.job.QuartzJobDeletedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.scheduler.QuartzSchedulerPausedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.scheduler.QuartzSchedulerStartedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.scheduler.QuartzSchedulerStoppedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.trigger.QuartzTriggerAddedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.trigger.QuartzTriggerDeletedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.trigger.QuartzTriggerGroupPausedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.trigger.QuartzTriggerGroupResumedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.trigger.QuartzTriggerPausedEvent;
import com.quartzdesk.agent.api.scheduler.quartz.trigger.QuartzTriggerResumedEvent;
import com.quartzdesk.api.agent.scheduler.quartz.v2_1_x.QuartzApiUtils;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.core.QuartzScheduler;

public class QuartzSchedulerListener
implements SchedulerListener {
    private static final Logger log = LoggerFactory.getLogger(QuartzSchedulerListener.class);
    private QuartzScheduler quartzScheduler;
    private ISchedulingEventInterceptor<QuartzEvent> schedulingEventInterceptor;

    public QuartzSchedulerListener(QuartzScheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
        this.schedulingEventInterceptor = Agent.getInstance().getSchedulingEventInterceptor(SchedulerType.QUARTZ);
    }

    public void jobScheduled(Trigger trigger) {
        log.debug("Invoked jobScheduled callback method of Quartz scheduler listener: {}, trigger: {}", (Object)this, (Object)trigger);
        try {
            QuartzTriggerAddedEvent event = QuartzApiUtils.prepareEvent(QuartzTriggerAddedEvent.class, this.quartzScheduler);
            event.setTriggerGroupName(trigger.getKey().getGroup());
            event.setTriggerName(trigger.getKey().getName());
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in jobScheduled callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void jobUnscheduled(TriggerKey triggerKey) {
        log.debug("Invoked jobUnscheduled callback method of Quartz scheduler listener: {}, triggerKey: {}", (Object)this, (Object)triggerKey);
        try {
            QuartzTriggerDeletedEvent event = QuartzApiUtils.prepareEvent(QuartzTriggerDeletedEvent.class, this.quartzScheduler);
            event.setTriggerGroupName(triggerKey.getGroup());
            event.setTriggerName(triggerKey.getName());
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in jobUnscheduled callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void triggerFinalized(Trigger trigger) {
    }

    public void triggerPaused(TriggerKey triggerKey) {
        log.debug("Invoked triggerPaused callback method of Quartz scheduler listener: {}, triggerKey: {}", (Object)this, (Object)triggerKey);
        try {
            QuartzTriggerPausedEvent event = QuartzApiUtils.prepareEvent(QuartzTriggerPausedEvent.class, this.quartzScheduler);
            event.setTriggerGroupName(triggerKey.getGroup());
            event.setTriggerName(triggerKey.getName());
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in triggerPaused callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void triggerResumed(TriggerKey triggerKey) {
        log.debug("Invoked triggerResumed callback method of Quartz scheduler listener: {}, triggerKey: {}", (Object)this, (Object)triggerKey);
        try {
            QuartzTriggerResumedEvent event = QuartzApiUtils.prepareEvent(QuartzTriggerResumedEvent.class, this.quartzScheduler);
            event.setTriggerGroupName(triggerKey.getGroup());
            event.setTriggerName(triggerKey.getName());
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in triggerResumed callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void triggersPaused(String triggerGroup) {
        log.debug("Invoked triggersPaused callback method of Quartz scheduler listener: {}, triggerGroup: {}", (Object)this, (Object)triggerGroup);
        try {
            QuartzTriggerGroupPausedEvent event = QuartzApiUtils.prepareEvent(QuartzTriggerGroupPausedEvent.class, this.quartzScheduler);
            event.setTriggerGroupName(triggerGroup);
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in triggersPaused callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void triggersResumed(String triggerGroup) {
        log.debug("Invoked triggersResumed callback method of Quartz scheduler listener: {}, triggerGroup: {}", (Object)this, (Object)triggerGroup);
        try {
            QuartzTriggerGroupResumedEvent event = QuartzApiUtils.prepareEvent(QuartzTriggerGroupResumedEvent.class, this.quartzScheduler);
            event.setTriggerGroupName(triggerGroup);
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in triggersResumed callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void jobAdded(JobDetail jobDetail) {
        log.debug("Invoked jobAdded callback method of Quartz scheduler listener: {}, jobDetail: {}", (Object)this, (Object)jobDetail);
        try {
            QuartzJobAddedEvent event = QuartzApiUtils.prepareEvent(QuartzJobAddedEvent.class, this.quartzScheduler);
            event.setJobGroupName(jobDetail.getKey().getGroup());
            event.setJobName(jobDetail.getKey().getName());
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in jobAdded callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void jobDeleted(JobKey jobKey) {
        log.debug("Invoked jobDeleted callback method of Quartz scheduler listener: {}, jobKey: {}", (Object)this, (Object)jobKey);
        try {
            QuartzJobDeletedEvent event = QuartzApiUtils.prepareEvent(QuartzJobDeletedEvent.class, this.quartzScheduler);
            event.setJobGroupName(jobKey.getGroup());
            event.setJobName(jobKey.getName());
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in jobDeleted callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void jobPaused(JobKey jobKey) {
    }

    public void jobResumed(JobKey jobKey) {
    }

    public void jobsPaused(String jobGroup) {
    }

    public void jobsResumed(String jobGroup) {
    }

    public void schedulerError(String msg, SchedulerException cause) {
    }

    public void schedulerInStandbyMode() {
        log.debug("Invoked schedulerInStandbyMode callback method of Quartz scheduler listener: {}", (Object)this);
        try {
            QuartzSchedulerPausedEvent event = QuartzApiUtils.prepareEvent(QuartzSchedulerPausedEvent.class, this.quartzScheduler);
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in schedulerInStandbyMode callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void schedulerStarted() {
        log.debug("Invoked schedulerStarted callback method of Quartz scheduler listener: {}", (Object)this);
        try {
            QuartzSchedulerStartedEvent event = QuartzApiUtils.prepareEvent(QuartzSchedulerStartedEvent.class, this.quartzScheduler);
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in schedulerStarted callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void schedulerShutdown() {
        log.debug("Invoked schedulerShutdown callback method of Quartz scheduler listener: {}", (Object)this);
        try {
            QuartzSchedulerStoppedEvent event = QuartzApiUtils.prepareEvent(QuartzSchedulerStoppedEvent.class, this.quartzScheduler);
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)event);
        }
        catch (Throwable e) {
            log.error("Error detected in schedulerShutdown callback method of Quartz scheduler listener: " + this, e);
        }
    }

    public void schedulerShuttingdown() {
    }

    public void schedulingDataCleared() {
    }
}

