/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v2_2_x.jmx;

import com.quartzdesk.agent.api.common.CommonConst;
import com.quartzdesk.agent.api.common.CommonUtils;
import com.quartzdesk.agent.api.common.text.DateTimeUtils;
import com.quartzdesk.agent.api.domain.model.common.DayTime;
import com.quartzdesk.agent.api.domain.model.common.Version;
import com.quartzdesk.agent.api.domain.model.common.Weekday;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendar;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCalendarIntervalTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzCronTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzDailyTimeIntervalTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMap;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobDataMapEntry;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzJobGroup;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzRepeatIntervalUnit;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzSimpleTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTrigger;
import com.quartzdesk.agent.api.domain.model.scheduler.quartz.QuartzTriggerGroup;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.CronTrigger;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.JobDataMap;
import org.quartz.SimpleTrigger;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;

public class Quartz2DomainTriggerConverter {
    private static final Logger log = LoggerFactory.getLogger(Quartz2DomainTriggerConverter.class);
    private Version schedulerVersion;

    public Quartz2DomainTriggerConverter(Version schedulerVersion) {
        this.schedulerVersion = schedulerVersion;
    }

    public <T extends QuartzTrigger> T convertTrigger(Trigger quartzTrigger, Locale locale) {
        if (quartzTrigger instanceof SimpleTrigger) {
            return (T)this.convertSimpleTrigger((SimpleTrigger)quartzTrigger, locale);
        }
        if (quartzTrigger instanceof CronTrigger) {
            return (T)this.convertCronTrigger((CronTrigger)quartzTrigger, locale);
        }
        if (quartzTrigger instanceof CalendarIntervalTrigger) {
            return (T)this.convertCalendarIntervalTrigger((CalendarIntervalTrigger)quartzTrigger, locale);
        }
        if (quartzTrigger instanceof DailyTimeIntervalTrigger) {
            return (T)this.convertDailyTimeIntervalTrigger((DailyTimeIntervalTrigger)quartzTrigger, locale);
        }
        throw new RuntimeException("Unexpected Quartz trigger type: " + quartzTrigger);
    }

    private QuartzSimpleTrigger convertSimpleTrigger(SimpleTrigger quartzTrigger, Locale locale) {
        QuartzSimpleTrigger trigger = this.populateCommonTriggerAttributes(new QuartzSimpleTrigger(), quartzTrigger, locale);
        trigger.withRepeatCount(Integer.valueOf(quartzTrigger.getRepeatCount())).withRepeatInterval(Long.valueOf(quartzTrigger.getRepeatInterval()));
        return trigger;
    }

    private QuartzCronTrigger convertCronTrigger(CronTrigger quartzTrigger, Locale locale) {
        QuartzCronTrigger trigger = this.populateCommonTriggerAttributes(new QuartzCronTrigger(), quartzTrigger, locale);
        trigger.withCronExpression(quartzTrigger.getCronExpression()).withTimeZone(this.convertTimeZone(quartzTrigger.getTimeZone(), locale));
        return trigger;
    }

    private QuartzCalendarIntervalTrigger convertCalendarIntervalTrigger(CalendarIntervalTrigger quartzTrigger, Locale locale) {
        QuartzCalendarIntervalTrigger trigger = this.populateCommonTriggerAttributes(new QuartzCalendarIntervalTrigger(), quartzTrigger, locale);
        trigger.withRepeatIntervalUnit(this.convertIntervalUnit(quartzTrigger.getRepeatIntervalUnit())).withRepeatInterval(Integer.valueOf(quartzTrigger.getRepeatInterval())).withTimeZone(this.convertTimeZone(quartzTrigger.getTimeZone(), locale)).withPreserveHourOfDayAcrossDaylightSavings(Boolean.valueOf(quartzTrigger.isPreserveHourOfDayAcrossDaylightSavings())).withSkipDayIfHourDoesNotExist(Boolean.valueOf(quartzTrigger.isSkipDayIfHourDoesNotExist()));
        return trigger;
    }

    private QuartzDailyTimeIntervalTrigger convertDailyTimeIntervalTrigger(DailyTimeIntervalTrigger quartzTrigger, Locale locale) {
        QuartzDailyTimeIntervalTrigger trigger = this.populateCommonTriggerAttributes(new QuartzDailyTimeIntervalTrigger(), quartzTrigger, locale);
        trigger.withRepeatIntervalUnit(this.convertIntervalUnit(quartzTrigger.getRepeatIntervalUnit())).withRepeatCount(Integer.valueOf(quartzTrigger.getRepeatCount())).withRepeatInterval(Integer.valueOf(quartzTrigger.getRepeatInterval())).withStartTimeOfDay(this.convertTimeOfDay(quartzTrigger.getStartTimeOfDay())).withEndTimeOfDay(this.convertTimeOfDay(quartzTrigger.getEndTimeOfDay())).withDaysOfWeek(this.convertDaysOfWeek(quartzTrigger.getDaysOfWeek()));
        return trigger;
    }

    private <T extends QuartzTrigger, Q extends Trigger> T populateCommonTriggerAttributes(T trigger, Q quartzTrigger, Locale locale) {
        trigger.withName(quartzTrigger.getKey().getName()).withGroup(new QuartzTriggerGroup().withName(quartzTrigger.getKey().getGroup())).withJobName(quartzTrigger.getJobKey().getName()).withJobGroup(new QuartzJobGroup().withName(quartzTrigger.getJobKey().getGroup())).withCalendar(this.convertCalendar(quartzTrigger.getCalendarName())).withDescription(quartzTrigger.getDescription()).withPriority(Integer.valueOf(quartzTrigger.getPriority())).withMisfireInstruction(Integer.valueOf(quartzTrigger.getMisfireInstruction())).withStartTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getStartTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withEndTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getEndTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withPreviousFireTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getPreviousFireTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withNextFireTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getNextFireTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withFinalFireTime(DateTimeUtils.date2Calendar((Date)quartzTrigger.getFinalFireTime(), (TimeZone)CommonConst.TIME_ZONE_UTC)).withJobDataMap(this.convertJobDataMap(quartzTrigger.getJobDataMap()));
        return trigger;
    }

    private QuartzRepeatIntervalUnit convertIntervalUnit(DateBuilder.IntervalUnit intervalUnit) {
        return intervalUnit == null ? null : QuartzRepeatIntervalUnit.valueOf((String)intervalUnit.name());
    }

    private DayTime convertTimeOfDay(TimeOfDay quartzTimeOfDay) {
        return quartzTimeOfDay == null ? null : new DayTime().withHours(Integer.valueOf(quartzTimeOfDay.getHour())).withMinutes(Integer.valueOf(quartzTimeOfDay.getMinute())).withSeconds(Integer.valueOf(quartzTimeOfDay.getSecond()));
    }

    private Collection<Weekday> convertDaysOfWeek(Set<Integer> quartzDaysOfWeek) {
        if (quartzDaysOfWeek == null) {
            return null;
        }
        EnumSet<Weekday> weekdays = EnumSet.noneOf(Weekday.class);
        block9: for (Integer dayOfWeek : quartzDaysOfWeek) {
            switch (dayOfWeek) {
                case 2: {
                    weekdays.add(Weekday.MONDAY);
                    continue block9;
                }
                case 3: {
                    weekdays.add(Weekday.TUESDAY);
                    continue block9;
                }
                case 4: {
                    weekdays.add(Weekday.WEDNESDAY);
                    continue block9;
                }
                case 5: {
                    weekdays.add(Weekday.THURSDAY);
                    continue block9;
                }
                case 6: {
                    weekdays.add(Weekday.FRIDAY);
                    continue block9;
                }
                case 7: {
                    weekdays.add(Weekday.SATURDAY);
                    continue block9;
                }
                case 1: {
                    weekdays.add(Weekday.SUNDAY);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unexpected day of week value: " + dayOfWeek);
        }
        return weekdays;
    }

    private QuartzJobDataMap convertJobDataMap(JobDataMap quartzJobDataMap) {
        if (quartzJobDataMap == null) {
            return null;
        }
        QuartzJobDataMap jobDataMap = new QuartzJobDataMap();
        for (Map.Entry entry : quartzJobDataMap.entrySet()) {
            jobDataMap.getEntry().add(new QuartzJobDataMapEntry().withName((String)entry.getKey()).withValue(CommonUtils.safeToString(entry.getValue())));
        }
        return jobDataMap;
    }

    private QuartzCalendar convertCalendar(String quartzCalendarName) {
        if (quartzCalendarName == null) {
            return null;
        }
        return new QuartzCalendar().withId(quartzCalendarName).withDisplayName(quartzCalendarName);
    }

    private com.quartzdesk.agent.api.domain.model.common.TimeZone convertTimeZone(TimeZone quartzTimeZone, Locale locale) {
        if (quartzTimeZone == null) {
            return null;
        }
        return new com.quartzdesk.agent.api.domain.model.common.TimeZone().withId(quartzTimeZone.getID()).withDisplayName(DateTimeUtils.formatTimeZone((TimeZone)quartzTimeZone, (Locale)locale)).withOffset(Integer.valueOf(quartzTimeZone.getRawOffset() / 1000));
    }
}

