/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.agent.scheduler.quartz.v2_2_x.listener;

import com.quartzdesk.agent.Agent;
import com.quartzdesk.agent.IAgent;
import com.quartzdesk.agent.api.AgentException;
import com.quartzdesk.agent.api.domain.convert.common.VersionConverter;
import com.quartzdesk.agent.api.domain.model.scheduler.ExecStatus;
import com.quartzdesk.agent.api.domain.model.scheduler.SchedulerType;
import com.quartzdesk.agent.api.scheduler.common.ISchedulingEvent;
import com.quartzdesk.agent.api.scheduler.common.ISchedulingEventInterceptor;
import com.quartzdesk.agent.api.scheduler.common.log.IExecutingJobLoggingInterceptor;
import com.quartzdesk.agent.api.scheduler.quartz.QuartzEvent;
import com.quartzdesk.agent.api.scheduler.quartz.job.QuartzJobExecutionEvent;
import com.quartzdesk.api.agent.scheduler.quartz.v2_2_x.QuartzApiUtils;
import ext.org.slf4j.Logger;
import ext.org.slf4j.LoggerFactory;
import java.util.Calendar;
import javax.management.ObjectName;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;

public class QuartzJobListener
implements JobListener {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobListener.class);
    private ObjectName schedObjectName;
    private IExecutingJobLoggingInterceptor loggingInterceptor;
    private ISchedulingEventInterceptor<QuartzEvent> schedulingEventInterceptor;
    private ThreadLocal<QuartzJobExecutionEvent> jobExecutionEventThreadLocal = new ThreadLocal();

    public QuartzJobListener(QuartzScheduler quartzScheduler) {
        this.schedObjectName = QuartzApiUtils.getSchedulerObjectName(quartzScheduler);
        IAgent agent = Agent.getInstance();
        this.loggingInterceptor = agent.getExecutingJobLoggingInterceptor();
        this.schedulingEventInterceptor = agent.getSchedulingEventInterceptor(SchedulerType.QUARTZ);
    }

    public String getName() {
        return "QuartzDeskJobListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        log.debug("Invoked jobToBeExecuted callback method in Quartz job listener: {}, context: {}", (Object)this, (Object)context);
        try {
            QuartzJobExecutionEvent jobExecEvent = this.createJobExecEvent(context);
            this.loggingInterceptor.startIntercept(Thread.currentThread(), jobExecEvent.getJobExecutionId(), jobExecEvent.getSchedulerObjectName(), jobExecEvent.getJobId());
            this.jobExecutionEventThreadLocal.set(jobExecEvent);
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)jobExecEvent);
        }
        catch (Throwable e) {
            log.error("Error detected in jobToBeExecuted callback method of Quartz job listener: " + this, e);
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        log.debug("Invoked jobExecutionVetoed callback method in Quartz job listener: {}, context: {}", (Object)this, (Object)context);
        try {
            QuartzJobExecutionEvent jobExecEvent = this.createJobExecEvent(context);
            jobExecEvent.setFinishedAt(jobExecEvent.getStartedAt());
            jobExecEvent.setExecStatus(ExecStatus.VETO);
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)jobExecEvent);
        }
        catch (Throwable e) {
            log.error("Error detected in jobExecutionVetoed callback method of Quartz job listener: " + this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Calendar finishedAt = Calendar.getInstance();
        log.debug("Invoked jobWasExecuted callback method in Quartz job listener: {}, context: {}, jobException: {}", new Object[]{this, context, jobException});
        QuartzJobExecutionEvent jobExecEvent = this.jobExecutionEventThreadLocal.get();
        try {
            jobExecEvent.setFinishedAt(finishedAt);
            jobExecEvent.setResult(context.getResult());
            jobExecEvent.setException((Exception)jobException);
            jobExecEvent.setUserData(context.get((Object)"USER_DATA"));
            jobExecEvent.setExecStatus(jobException == null ? ExecStatus.SUCCESS : ExecStatus.ERROR);
            jobExecEvent.setExecutingJobLoggingEventStore(this.loggingInterceptor.getLoggingEventStore(Thread.currentThread()));
            this.schedulingEventInterceptor.onEvent((ISchedulingEvent)jobExecEvent);
        }
        catch (Throwable e) {
            log.error("Error detected in jobWasExecuted callback method of Quartz job listener: " + this, e);
        }
        finally {
            this.jobExecutionEventThreadLocal.remove();
            this.loggingInterceptor.stopIntercept(Thread.currentThread(), jobExecEvent.getJobExecutionId());
        }
    }

    protected QuartzJobExecutionEvent createJobExecEvent(JobExecutionContext context) {
        SchedulerMetaData schedMetaData;
        QuartzJobExecutionEvent jobExecEvent = new QuartzJobExecutionEvent();
        jobExecEvent.setJobId(this.getJobId(context));
        Calendar startedAt = Calendar.getInstance();
        startedAt.setTime(context.getFireTime());
        jobExecEvent.setStartedAt(startedAt);
        Scheduler scheduler = context.getScheduler();
        try {
            schedMetaData = scheduler.getMetaData();
        }
        catch (SchedulerException e) {
            throw new AgentException("Error obtaining scheduler meta-data.", (Throwable)e);
        }
        jobExecEvent.setSchedulerObjectName(this.schedObjectName);
        jobExecEvent.setSchedulerVersion(VersionConverter.INSTANCE.fromString(schedMetaData.getVersion()));
        jobExecEvent.setSchedulerName(schedMetaData.getSchedulerName());
        jobExecEvent.setSchedulerInstanceId(schedMetaData.getSchedulerInstanceId());
        JobDetail jobDetail = context.getJobDetail();
        jobExecEvent.setJobGroupName(jobDetail.getKey().getGroup());
        jobExecEvent.setJobName(jobDetail.getKey().getName());
        jobExecEvent.setJobClassName(jobDetail.getJobClass().getName());
        jobExecEvent.setJobClassLocation(jobDetail.getJobClass().getProtectionDomain().getCodeSource().getLocation());
        jobExecEvent.setMergedJobDataMap(QuartzApiUtils.toEventJobDataMap(context.getMergedJobDataMap()));
        Trigger trigger = context.getTrigger();
        jobExecEvent.setTriggerGroupName(trigger.getKey().getGroup());
        jobExecEvent.setTriggerName(trigger.getKey().getName());
        jobExecEvent.setCalendarName(trigger.getCalendarName());
        jobExecEvent.setFireInstanceId(context.getFireInstanceId());
        return jobExecEvent;
    }

    protected String getJobId(JobExecutionContext context) {
        return context.getJobDetail().getKey().toString();
    }
}

