/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.common.encoding;

import com.quartzdesk.api.common.encoding.EncodingException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public final class BASE64Decoder {
    private BASE64Decoder() {
    }

    public static byte[] decode(String s) throws EncodingException {
        if (s == null) {
            return null;
        }
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream(s.length());
            byte[] bytes = s.getBytes("ISO-8859-1");
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] == 10 || bytes[i] == 13) {
                    ++i;
                    continue;
                }
                int first = BASE64Decoder.translate(bytes[i++]);
                int second = BASE64Decoder.translate(bytes[i++]);
                int third = BASE64Decoder.translate(bytes[i++]);
                int fourth = BASE64Decoder.translate(bytes[i++]);
                if (first != -1) {
                    if (second != -1) {
                        ba.write((byte)(first << 2 | (second & 0x30) >>> 4));
                        if (third != -1) {
                            ba.write((byte)((second & 0xF) << 4 | (third & 0x3C) >>> 2));
                            if (fourth == -1) break;
                            ba.write((byte)((third & 3) << 6 | fourth));
                            continue;
                        }
                        if (fourth == -1) break;
                        throw new EncodingException("Not MIME BASE64 data format.");
                    }
                    throw new EncodingException("Second character in a quad cannot be =.");
                }
                throw new EncodingException("First character in a quad cannot be =.");
            }
            return ba.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("Unable to extract input string bytes.", e);
        }
    }

    private static int translate(byte b) throws EncodingException {
        if (b >= 65 && b <= 90) {
            return b - 65;
        }
        if (b >= 97 && b <= 122) {
            return b - 97 + 26;
        }
        if (b >= 48 && b <= 57) {
            return b - 48 + 52;
        }
        if (b == 43) {
            return 62;
        }
        if (b == 47) {
            return 63;
        }
        if (b == 61) {
            return -1;
        }
        throw new EncodingException("Not MIME BASE64 character: 0x" + Character.digit((char)b, 16));
    }
}

