/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.common.encoding;

public final class BASE64Encoder {
    private static final int PAD_CHAR_INDEX = 64;
    private static final char[] BASE64_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    private BASE64Encoder() {
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (bytes == null) {
            return null;
        }
        while (i < bytes.length) {
            int first;
            if ((first = bytes[i++]) < 0) {
                first += 256;
            }
            sb.append(BASE64_ALPHABET[first >>> 2]);
            if (i < bytes.length) {
                int second;
                if ((second = bytes[i++]) < 0) {
                    second += 256;
                }
                sb.append(BASE64_ALPHABET[second >>> 4 | (first & 3) << 4]);
                if (i < bytes.length) {
                    int third;
                    if ((third = bytes[i++]) < 0) {
                        third += 256;
                    }
                    sb.append(BASE64_ALPHABET[third >>> 6 | (second & 0xF) << 2]);
                    sb.append(BASE64_ALPHABET[third & 0x3F]);
                    continue;
                }
                sb.append(BASE64_ALPHABET[(second & 0xF) << 2]);
                sb.append(BASE64_ALPHABET[64]);
                continue;
            }
            sb.append(BASE64_ALPHABET[(first & 3) << 4]);
            sb.append(BASE64_ALPHABET[64]);
            sb.append(BASE64_ALPHABET[64]);
        }
        return sb.toString();
    }
}

