/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.api.web.security;

import com.quartzdesk.api.common.encoding.BASE64Decoder;
import com.quartzdesk.api.common.encoding.BASE64Encoder;
import com.quartzdesk.api.common.security.SecurityUtils;
import com.quartzdesk.api.web.security.SecurityToken;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class SecurityTokenUtils {
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGORITHM = "AES";
    private static final Random RANDOM = new SecureRandom();
    private static final byte[] IV = new byte[]{118, -50, -93, 39, 5, -45, -102, 99, 37, 87, -78, 113, 3, 111, -100, 65};
    private static final AlgorithmParameterSpec PARAM_SPEC = new IvParameterSpec(IV);

    private SecurityTokenUtils() {
    }

    public static String encrypt(String symmetricKey, SecurityToken securityToken) {
        try {
            SecretKey secretKey = SecurityUtils.symmetricKeyFromBASE64(symmetricKey, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, (Key)secretKey, PARAM_SPEC);
            StringBuilder plainTextData = new StringBuilder().append(Math.abs(RANDOM.nextInt(65535))).append('|').append(securityToken.getValidTo().getTime()).append('|').append(securityToken.getPrincipalName());
            byte[] result = cipher.doFinal(plainTextData.toString().getBytes("UTF-8"));
            return BASE64Encoder.encode(result);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static SecurityToken decrypt(String symmetricKey, String securityTokenStr) {
        try {
            SecretKey secretKey = SecurityUtils.symmetricKeyFromBASE64(symmetricKey, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, (Key)secretKey, PARAM_SPEC);
            String plainTextData = new String(cipher.doFinal(BASE64Decoder.decode(securityTokenStr)), "UTF-8");
            String[] components = plainTextData.split("\\|", -1);
            if (components.length != 3) {
                throw new SecurityException("Invalid number of components in the security token: " + components.length);
            }
            String validToStr = components[1];
            String principalName = components[2];
            if (principalName.isEmpty()) {
                principalName = null;
            }
            Calendar validTo = Calendar.getInstance();
            validTo.setTimeInMillis(Long.parseLong(validToStr));
            Calendar now = Calendar.getInstance();
            if (now.after(validTo)) {
                throw new SecurityException("Security token expired on: " + validTo.getTime());
            }
            return new SecurityToken(principalName, validTo.getTime());
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }
}

