/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.service.api.fault.v1_0;

import com.quartzdesk.service.types.v1_0.fault.FaultInfo;
import com.quartzdesk.service.types.v1_0.fault.SecurityFaultInfo;
import com.quartzdesk.service.types.v1_0.fault.ServiceFaultInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class FaultInfoFactory {
    public ServiceFaultInfo createServiceFaultInfo(String message) {
        return new ServiceFaultInfo().withMessage(message);
    }

    public ServiceFaultInfo createServiceFaultInfo(Throwable e) {
        StringWriter stackTraceWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTraceWriter));
        return new ServiceFaultInfo().withMessage(e.getMessage()).withStackTrace(stackTraceWriter.toString()).withCause(this.createCauseFaultInfo(e));
    }

    public SecurityFaultInfo createSecurityFaultInfo(String message) {
        return new SecurityFaultInfo().withMessage(message);
    }

    public SecurityFaultInfo createSecurityFaultInfo(Throwable e) {
        StringWriter stackTraceWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTraceWriter));
        return new SecurityFaultInfo().withMessage(e.getMessage()).withStackTrace(stackTraceWriter.toString()).withCause(this.createCauseFaultInfo(e));
    }

    private FaultInfo createCauseFaultInfo(Throwable e) {
        Throwable cause = this.getCause(e);
        if (cause == null) {
            return null;
        }
        StringWriter stackTraceWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTraceWriter));
        return new FaultInfo().withMessage(cause.getMessage()).withStackTrace(stackTraceWriter.toString()).withCause(this.createCauseFaultInfo(cause));
    }

    private Throwable getCause(Throwable t) {
        if (t instanceof SQLException) {
            return ((SQLException)t).getNextException();
        }
        return t.getCause();
    }
}

