/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.service.api.jaxb.adapter;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class XsdDate2CalendarAdapter
extends XmlAdapter<String, Calendar> {
    public Calendar unmarshal(String value) {
        return DatatypeConverter.parseDate((String)value);
    }

    public String marshal(Calendar value) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        dateFormat.setTimeZone(value.getTimeZone());
        return dateFormat.format(value.getTime()) + this.formatTimeZoneOffset(value.getTimeZone());
    }

    private String formatTimeZoneOffset(TimeZone timeZone) {
        int offsetSeconds = timeZone.getRawOffset() / 1000;
        int offsetHours = Math.abs(offsetSeconds / 3600);
        int offsetMinutes = (Math.abs(offsetSeconds) - offsetHours * 3600) / 60;
        StringBuilder offset = new StringBuilder();
        if (offsetSeconds >= 0) {
            offset.append('+');
        } else {
            offset.append('-');
        }
        if (offsetHours < 10) {
            offset.append('0');
        }
        offset.append(offsetHours);
        offset.append(':');
        if (offsetMinutes < 10) {
            offset.append('0');
        }
        offset.append(offsetMinutes);
        return offset.toString();
    }
}

