/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.service.client.connection.v3_0;

import com.quartzdesk.service.connection.v3_0.AddConnectionRequest;
import com.quartzdesk.service.connection.v3_0.AddConnectionResponse;
import com.quartzdesk.service.connection.v3_0.AddFolderRequest;
import com.quartzdesk.service.connection.v3_0.AddFolderResponse;
import com.quartzdesk.service.connection.v3_0.ConnectionService;
import com.quartzdesk.service.connection.v3_0.ConnectionService_Service;
import com.quartzdesk.service.connection.v3_0.DeleteConnectionRequest;
import com.quartzdesk.service.connection.v3_0.DeleteConnectionResponse;
import com.quartzdesk.service.connection.v3_0.DeleteFolderRequest;
import com.quartzdesk.service.connection.v3_0.DeleteFolderResponse;
import com.quartzdesk.service.connection.v3_0.GetConnectionRequest;
import com.quartzdesk.service.connection.v3_0.GetConnectionResponse;
import com.quartzdesk.service.connection.v3_0.GetConnectionsRequest;
import com.quartzdesk.service.connection.v3_0.GetConnectionsResponse;
import com.quartzdesk.service.connection.v3_0.GetFolderRequest;
import com.quartzdesk.service.connection.v3_0.GetFolderResponse;
import com.quartzdesk.service.connection.v3_0.GetFoldersRequest;
import com.quartzdesk.service.connection.v3_0.GetFoldersResponse;
import com.quartzdesk.service.connection.v3_0.MoveConnectionRequest;
import com.quartzdesk.service.connection.v3_0.MoveConnectionResponse;
import com.quartzdesk.service.connection.v3_0.MoveFolderRequest;
import com.quartzdesk.service.connection.v3_0.MoveFolderResponse;
import com.quartzdesk.service.connection.v3_0.PauseAllConnectionsRequest;
import com.quartzdesk.service.connection.v3_0.PauseAllConnectionsResponse;
import com.quartzdesk.service.connection.v3_0.RenameFolderRequest;
import com.quartzdesk.service.connection.v3_0.RenameFolderResponse;
import com.quartzdesk.service.connection.v3_0.SecurityFault;
import com.quartzdesk.service.connection.v3_0.ServiceFault;
import com.quartzdesk.service.connection.v3_0.StartAllConnectionsRequest;
import com.quartzdesk.service.connection.v3_0.StartAllConnectionsResponse;
import com.quartzdesk.service.connection.v3_0.StopAllConnectionsRequest;
import com.quartzdesk.service.connection.v3_0.StopAllConnectionsResponse;
import com.quartzdesk.service.connection.v3_0.UpdateConnectionRequest;
import com.quartzdesk.service.connection.v3_0.UpdateConnectionResponse;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class ConnectionServiceClient
implements ConnectionService {
    private static final Integer DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final Integer DEFAULT_RECEIVE_TIMEOUT = 30000;
    private ConnectionService port;

    public ConnectionServiceClient(String endpointUrl, String username, String password) {
        this.port = this.createServicePort(endpointUrl, username, password, DEFAULT_CONNECT_TIMEOUT, DEFAULT_RECEIVE_TIMEOUT);
    }

    public ConnectionServiceClient(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        this.port = this.createServicePort(endpointUrl, username, password, connectTimeout, receiveTimeout);
    }

    @Override
    public GetFolderResponse getFolder(GetFolderRequest request) throws SecurityFault, ServiceFault {
        return this.port.getFolder(request);
    }

    @Override
    public GetFoldersResponse getFolders(GetFoldersRequest request) throws SecurityFault, ServiceFault {
        return this.port.getFolders(request);
    }

    @Override
    public AddFolderResponse addFolder(AddFolderRequest request) throws SecurityFault, ServiceFault {
        return this.port.addFolder(request);
    }

    @Override
    public RenameFolderResponse renameFolder(RenameFolderRequest request) throws SecurityFault, ServiceFault {
        return this.port.renameFolder(request);
    }

    @Override
    public MoveFolderResponse moveFolder(MoveFolderRequest request) throws SecurityFault, ServiceFault {
        return this.port.moveFolder(request);
    }

    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest request) throws SecurityFault, ServiceFault {
        return this.port.deleteFolder(request);
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) throws SecurityFault, ServiceFault {
        return this.port.getConnection(request);
    }

    @Override
    public GetConnectionsResponse getConnections(GetConnectionsRequest request) throws SecurityFault, ServiceFault {
        return this.port.getConnections(request);
    }

    @Override
    public AddConnectionResponse addConnection(AddConnectionRequest request) throws SecurityFault, ServiceFault {
        return this.port.addConnection(request);
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) throws SecurityFault, ServiceFault {
        return this.port.updateConnection(request);
    }

    @Override
    public MoveConnectionResponse moveConnection(MoveConnectionRequest request) throws SecurityFault, ServiceFault {
        return this.port.moveConnection(request);
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) throws SecurityFault, ServiceFault {
        return this.port.deleteConnection(request);
    }

    @Override
    public StartAllConnectionsResponse startAllConnections(StartAllConnectionsRequest request) throws SecurityFault, ServiceFault {
        return this.port.startAllConnections(request);
    }

    @Override
    public PauseAllConnectionsResponse pauseAllConnections(PauseAllConnectionsRequest request) throws SecurityFault, ServiceFault {
        return this.port.pauseAllConnections(request);
    }

    @Override
    public StopAllConnectionsResponse stopAllConnections(StopAllConnectionsRequest request) throws SecurityFault, ServiceFault {
        return this.port.stopAllConnections(request);
    }

    private ConnectionService createServicePort(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        ConnectionService_Service service = new ConnectionService_Service();
        ConnectionService port = service.getConnectionServicePort();
        Map requestContext = ((BindingProvider)port).getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpointUrl);
        if (username != null) {
            requestContext.put("javax.xml.ws.security.auth.username", username);
        }
        if (password != null) {
            requestContext.put("javax.xml.ws.security.auth.password", password);
        }
        requestContext.put("javax.xml.ws.client.connectionTimeout", connectTimeout == null ? DEFAULT_CONNECT_TIMEOUT : connectTimeout);
        requestContext.put("javax.xml.ws.client.receiveTimeout", receiveTimeout == null ? DEFAULT_RECEIVE_TIMEOUT : receiveTimeout);
        return port;
    }
}

