/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.service.client.quartz_exec_history.v2_0;

import com.quartzdesk.service.quartz_exec_history.v2_0.GetHistoryForJobRequest;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetHistoryForJobResponse;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetHistoryForSchedulerRequest;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetHistoryForSchedulerResponse;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetHistoryForTriggerRequest;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetHistoryForTriggerResponse;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetLogRequest;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetLogResponse;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetResultRequest;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetResultResponse;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetUserDataRequest;
import com.quartzdesk.service.quartz_exec_history.v2_0.GetUserDataResponse;
import com.quartzdesk.service.quartz_exec_history.v2_0.QuartzExecHistoryService;
import com.quartzdesk.service.quartz_exec_history.v2_0.QuartzExecHistoryService_Service;
import com.quartzdesk.service.quartz_exec_history.v2_0.SecurityFault;
import com.quartzdesk.service.quartz_exec_history.v2_0.ServiceFault;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class QuartzExecHistoryServiceClient
implements QuartzExecHistoryService {
    private static final Integer DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final Integer DEFAULT_RECEIVE_TIMEOUT = 30000;
    private QuartzExecHistoryService port;

    public QuartzExecHistoryServiceClient(String endpointUrl, String username, String password) {
        this.port = this.createServicePort(endpointUrl, username, password, DEFAULT_CONNECT_TIMEOUT, DEFAULT_RECEIVE_TIMEOUT);
    }

    public QuartzExecHistoryServiceClient(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        this.port = this.createServicePort(endpointUrl, username, password, connectTimeout, receiveTimeout);
    }

    @Override
    public GetHistoryForJobResponse getHistoryForJob(GetHistoryForJobRequest request) throws SecurityFault, ServiceFault {
        return this.port.getHistoryForJob(request);
    }

    @Override
    public GetHistoryForTriggerResponse getHistoryForTrigger(GetHistoryForTriggerRequest request) throws SecurityFault, ServiceFault {
        return this.port.getHistoryForTrigger(request);
    }

    @Override
    public GetHistoryForSchedulerResponse getHistoryForScheduler(GetHistoryForSchedulerRequest request) throws SecurityFault, ServiceFault {
        return this.port.getHistoryForScheduler(request);
    }

    @Override
    public GetResultResponse getResult(GetResultRequest request) throws SecurityFault, ServiceFault {
        return this.port.getResult(request);
    }

    @Override
    public GetUserDataResponse getUserData(GetUserDataRequest request) throws SecurityFault, ServiceFault {
        return this.port.getUserData(request);
    }

    @Override
    public GetLogResponse getLog(GetLogRequest request) throws SecurityFault, ServiceFault {
        return this.port.getLog(request);
    }

    private QuartzExecHistoryService createServicePort(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        QuartzExecHistoryService_Service service = new QuartzExecHistoryService_Service();
        QuartzExecHistoryService port = service.getQuartzExecHistoryServicePort();
        Map requestContext = ((BindingProvider)port).getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpointUrl);
        if (username != null) {
            requestContext.put("javax.xml.ws.security.auth.username", username);
        }
        if (password != null) {
            requestContext.put("javax.xml.ws.security.auth.password", password);
        }
        requestContext.put("javax.xml.ws.client.connectionTimeout", connectTimeout == null ? DEFAULT_CONNECT_TIMEOUT : connectTimeout);
        requestContext.put("javax.xml.ws.client.receiveTimeout", receiveTimeout == null ? DEFAULT_RECEIVE_TIMEOUT : receiveTimeout);
        return port;
    }
}

