/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.service.client.quartz_exec_notif_rule.v1_0;

import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.AddRuleRequest;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.AddRuleResponse;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.DeleteRuleRequest;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.DeleteRuleResponse;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRuleRequest;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRuleResponse;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRulesForJobRequest;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRulesForJobResponse;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRulesForSchedulerRequest;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRulesForSchedulerResponse;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRulesForTriggerRequest;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.GetRulesForTriggerResponse;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.QuartzExecNotificationRuleService;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.QuartzExecNotificationRuleService_Service;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.SecurityFault;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.ServiceFault;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.UpdateRuleRequest;
import com.quartzdesk.service.quartz_exec_notif_rule.v1_0.UpdateRuleResponse;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class QuartzExecNotificationRuleServiceClient
implements QuartzExecNotificationRuleService {
    private static final Integer DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final Integer DEFAULT_RECEIVE_TIMEOUT = 30000;
    private QuartzExecNotificationRuleService port;

    public QuartzExecNotificationRuleServiceClient(String endpointUrl, String username, String password) {
        this.port = this.createServicePort(endpointUrl, username, password, DEFAULT_CONNECT_TIMEOUT, DEFAULT_RECEIVE_TIMEOUT);
    }

    public QuartzExecNotificationRuleServiceClient(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        this.port = this.createServicePort(endpointUrl, username, password, connectTimeout, receiveTimeout);
    }

    @Override
    public GetRulesForJobResponse getRulesForJob(GetRulesForJobRequest request) throws SecurityFault, ServiceFault {
        return this.port.getRulesForJob(request);
    }

    @Override
    public GetRulesForTriggerResponse getRulesForTrigger(GetRulesForTriggerRequest request) throws SecurityFault, ServiceFault {
        return this.port.getRulesForTrigger(request);
    }

    @Override
    public GetRulesForSchedulerResponse getRulesForScheduler(GetRulesForSchedulerRequest request) throws SecurityFault, ServiceFault {
        return this.port.getRulesForScheduler(request);
    }

    @Override
    public GetRuleResponse getRule(GetRuleRequest request) throws SecurityFault, ServiceFault {
        return this.port.getRule(request);
    }

    @Override
    public AddRuleResponse addRule(AddRuleRequest request) throws SecurityFault, ServiceFault {
        return this.port.addRule(request);
    }

    @Override
    public UpdateRuleResponse updateRule(UpdateRuleRequest request) throws SecurityFault, ServiceFault {
        return this.port.updateRule(request);
    }

    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest request) throws SecurityFault, ServiceFault {
        return this.port.deleteRule(request);
    }

    private QuartzExecNotificationRuleService createServicePort(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        QuartzExecNotificationRuleService_Service service = new QuartzExecNotificationRuleService_Service();
        QuartzExecNotificationRuleService port = service.getQuartzExecNotificationRuleServicePort();
        Map requestContext = ((BindingProvider)port).getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpointUrl);
        if (username != null) {
            requestContext.put("javax.xml.ws.security.auth.username", username);
        }
        if (password != null) {
            requestContext.put("javax.xml.ws.security.auth.password", password);
        }
        requestContext.put("javax.xml.ws.client.connectionTimeout", connectTimeout == null ? DEFAULT_CONNECT_TIMEOUT : connectTimeout);
        requestContext.put("javax.xml.ws.client.receiveTimeout", receiveTimeout == null ? DEFAULT_RECEIVE_TIMEOUT : receiveTimeout);
        return port;
    }
}

