/*
 * Decompiled with CFR 0.152.
 */
package com.quartzdesk.service.client.quartz_job_chain.v1_0;

import com.quartzdesk.service.quartz_job_chain.v1_0.AddJobChainRequest;
import com.quartzdesk.service.quartz_job_chain.v1_0.AddJobChainResponse;
import com.quartzdesk.service.quartz_job_chain.v1_0.DeleteJobChainRequest;
import com.quartzdesk.service.quartz_job_chain.v1_0.DeleteJobChainResponse;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainRequest;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainResponse;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainsForJobRequest;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainsForJobResponse;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainsForSchedulerRequest;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainsForSchedulerResponse;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainsForTriggerRequest;
import com.quartzdesk.service.quartz_job_chain.v1_0.GetJobChainsForTriggerResponse;
import com.quartzdesk.service.quartz_job_chain.v1_0.QuartzJobChainService;
import com.quartzdesk.service.quartz_job_chain.v1_0.QuartzJobChainService_Service;
import com.quartzdesk.service.quartz_job_chain.v1_0.SecurityFault;
import com.quartzdesk.service.quartz_job_chain.v1_0.ServiceFault;
import com.quartzdesk.service.quartz_job_chain.v1_0.UpdateJobChainRequest;
import com.quartzdesk.service.quartz_job_chain.v1_0.UpdateJobChainResponse;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class QuartzJobChainServiceClient
implements QuartzJobChainService {
    private static final Integer DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final Integer DEFAULT_RECEIVE_TIMEOUT = 30000;
    private QuartzJobChainService port;

    public QuartzJobChainServiceClient(String endpointUrl, String username, String password) {
        this.port = this.createServicePort(endpointUrl, username, password, DEFAULT_CONNECT_TIMEOUT, DEFAULT_RECEIVE_TIMEOUT);
    }

    public QuartzJobChainServiceClient(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        this.port = this.createServicePort(endpointUrl, username, password, connectTimeout, receiveTimeout);
    }

    @Override
    public GetJobChainsForJobResponse getJobChainsForJob(GetJobChainsForJobRequest request) throws SecurityFault, ServiceFault {
        return this.port.getJobChainsForJob(request);
    }

    @Override
    public GetJobChainsForTriggerResponse getJobChainsForTrigger(GetJobChainsForTriggerRequest request) throws SecurityFault, ServiceFault {
        return this.port.getJobChainsForTrigger(request);
    }

    @Override
    public GetJobChainsForSchedulerResponse getJobChainsForScheduler(GetJobChainsForSchedulerRequest request) throws SecurityFault, ServiceFault {
        return this.port.getJobChainsForScheduler(request);
    }

    @Override
    public GetJobChainResponse getJobChain(GetJobChainRequest request) throws SecurityFault, ServiceFault {
        return this.port.getJobChain(request);
    }

    @Override
    public AddJobChainResponse addJobChain(AddJobChainRequest request) throws SecurityFault, ServiceFault {
        return this.port.addJobChain(request);
    }

    @Override
    public UpdateJobChainResponse updateJobChain(UpdateJobChainRequest request) throws SecurityFault, ServiceFault {
        return this.port.updateJobChain(request);
    }

    @Override
    public DeleteJobChainResponse deleteJobChain(DeleteJobChainRequest request) throws SecurityFault, ServiceFault {
        return this.port.deleteJobChain(request);
    }

    private QuartzJobChainService createServicePort(String endpointUrl, String username, String password, Integer connectTimeout, Integer receiveTimeout) {
        QuartzJobChainService_Service service = new QuartzJobChainService_Service();
        QuartzJobChainService port = service.getQuartzJobChainServicePort();
        Map requestContext = ((BindingProvider)port).getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpointUrl);
        if (username != null) {
            requestContext.put("javax.xml.ws.security.auth.username", username);
        }
        if (password != null) {
            requestContext.put("javax.xml.ws.security.auth.password", password);
        }
        requestContext.put("javax.xml.ws.client.connectionTimeout", connectTimeout == null ? DEFAULT_CONNECT_TIMEOUT : connectTimeout);
        requestContext.put("javax.xml.ws.client.receiveTimeout", receiveTimeout == null ? DEFAULT_RECEIVE_TIMEOUT : receiveTimeout);
        return port;
    }
}

