/*
 * Decompiled with CFR 0.152.
 */
package com.quasiris.qsf.commons.ai;

import com.quasiris.qsf.commons.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRepositoryManager {
    private static final Logger logger = LoggerFactory.getLogger(ModelRepositoryManager.class);
    private String groupId;
    private String artifactId;
    private String version;
    private String modelBaseUrl;
    private String uploadBaseUrl;
    private String modelBasePath;

    protected String getModelName() {
        return this.artifactId + "-" + this.version;
    }

    protected String getUrlZipFile() {
        return this.getUrlPath() + this.getModelName() + ".zip";
    }

    public static String resolvePath(String modelname, String path) {
        if (StringUtils.isNotBlank((CharSequence)modelname) && StringUtils.isNotBlank((CharSequence)path)) {
            String relativeModelPath = ModelRepositoryManager.resolvePath(modelname);
            path = path.replace(modelname, relativeModelPath);
        }
        return path;
    }

    public static String resolvePath(String modelname) {
        String path = null;
        if (StringUtils.isNotBlank((CharSequence)modelname)) {
            CharSequence[] parts = modelname.split("\\|");
            if (parts.length == 3) {
                parts[0] = parts[0].replaceAll("\\.", File.separator);
                String artifact = parts[1] + "-" + parts[2];
                path = String.join((CharSequence)File.separator, parts);
                path = String.join((CharSequence)File.separator, path, artifact);
            } else {
                throw new RuntimeException("Invalid Modelname: " + modelname);
            }
        }
        return path;
    }

    protected String getUrlPath() {
        StringBuilder groupIdPath = new StringBuilder(this.groupId.replaceAll(Pattern.quote("."), "/"));
        groupIdPath.append("/");
        groupIdPath.append(this.artifactId);
        groupIdPath.append("/");
        groupIdPath.append(this.version);
        groupIdPath.append("/");
        return groupIdPath.toString();
    }

    public void save(String sourceDir) throws IOException {
        String absoluteModelPath = this.getAbsoluteModelPath();
        IOUtils.createDirectoryIfNotExists(absoluteModelPath);
        String zipFileName = this.getZipFile();
        IOUtils.zip(sourceDir, this.getModelName(), zipFileName);
    }

    public void saveAndUpload(String sourceDir) throws IOException {
        this.save(sourceDir);
        this.upload(this.getZipFile());
    }

    public void save(InputStream zipFileInputStream) throws IOException {
        String absoluteModelPath = this.getAbsoluteModelPath();
        IOUtils.createDirectoryIfNotExists(absoluteModelPath);
        String zipFile = this.getZipFile();
        IOUtils.copyInputStreamToFile(zipFileInputStream, new File(zipFile));
    }

    public InputStream load(String fileName) throws FileNotFoundException {
        this.install();
        String absoluteFile = this.getAbsoluteModelFile(fileName);
        return new FileInputStream(new File(absoluteFile));
    }

    protected boolean isInstalled() {
        Path path = Paths.get(this.getAbsoluteModelFile(), new String[0]);
        return Files.exists(path, new LinkOption[0]) && Files.isReadable(path) && Files.isWritable(path);
    }

    public void install() {
        if (!this.isInstalled()) {
            logger.warn("Model {} is not installed locally!", (Object)this.getModelName());
            this.download();
            this.unzip();
        } else {
            logger.info("Found installed model {}", (Object)this.getModelName());
        }
    }

    protected String getModelUrl() {
        return this.modelBaseUrl + this.getUrlZipFile();
    }

    protected String getAbsoluteModelPath() {
        return this.modelBasePath + this.getUrlPath();
    }

    public String getAbsoluteModelFile() {
        return this.modelBasePath + this.getUrlPath() + this.getModelName() + "/";
    }

    public String getAbsoluteModelFile(String fileName) {
        return this.getAbsoluteModelFile() + fileName;
    }

    protected String getUploadUrl() {
        StringBuilder uploadUrl = new StringBuilder(this.uploadBaseUrl);
        uploadUrl.append(this.groupId);
        uploadUrl.append("/");
        uploadUrl.append(this.artifactId);
        uploadUrl.append("/");
        uploadUrl.append(this.version);
        return uploadUrl.toString();
    }

    public void upload(String fileName) throws IOException {
        String url = this.getUploadUrl();
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost post = new HttpPost(url);
            File file = new File(fileName);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("file", file, ContentType.DEFAULT_BINARY, fileName);
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() >= 300) {
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new RuntimeException("Could not upload file " + fileName + " to url: " + url + " http code: " + response.getStatusLine().getStatusCode() + " message: " + responseBody);
            }
            httpclient.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void download() {
        String modelUrl = this.getModelUrl();
        String path = this.getAbsoluteModelPath();
        IOUtils.createDirectoryIfNotExists(path);
        logger.info("Downloading model {} from url: {} to path: {} ", new Object[]{this.getModelName(), modelUrl, this.getZipFile()});
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(modelUrl);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() < 300) {
                try (InputStream inputStream = response.getEntity().getContent();){
                    Files.copy(inputStream, Paths.get(this.getZipFile(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                int statusCode = response.getStatusLine().getStatusCode();
                httpclient.close();
                throw new HttpResponseException(statusCode, responseBody);
            }
            httpclient.close();
            logger.info("Unzipping finished!");
        }
        catch (Exception e) {
            throw new RuntimeException("Something gone wrong while downloading model file from " + modelUrl, e);
        }
    }

    protected String getZipFile() {
        return this.modelBasePath + this.getUrlZipFile();
    }

    protected void unzip() {
        String zipFile = this.getZipFile();
        try {
            logger.info("Unzipping downloaded file {}", (Object)zipFile);
            IOUtils.unzip(zipFile);
            logger.info("Finished Unzipping file {}", (Object)zipFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not unzip file: " + zipFile, e);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getModelBaseUrl() {
        return this.modelBaseUrl;
    }

    public void setModelBaseUrl(String modelBaseUrl) {
        this.modelBaseUrl = IOUtils.ensureEndingSlash(modelBaseUrl);
    }

    public String getModelBasePath() {
        return this.modelBasePath;
    }

    public void setModelBasePath(String modelBasePath) {
        this.modelBasePath = IOUtils.ensureEndingSlash(modelBasePath);
    }

    public String getUploadBaseUrl() {
        return this.uploadBaseUrl;
    }

    public void setUploadBaseUrl(String uploadBaseUrl) {
        this.uploadBaseUrl = IOUtils.ensureEndingSlash(uploadBaseUrl);
    }

    public static final class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private String modelBaseUrl;
        private String modelBasePath;
        private String uploadBaseUrl;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder shortId(String shortId) {
            String[] splitted = shortId.split(Pattern.quote("|"));
            if (splitted.length < 3) {
                throw new IllegalArgumentException("The short id: " + shortId + " is invalid.");
            }
            this.groupId = splitted[0];
            this.artifactId = splitted[1];
            this.version = splitted[2];
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder modelBaseUrl(String modelBaseUrl) {
            this.modelBaseUrl = modelBaseUrl;
            return this;
        }

        public Builder modelBasePath(String modelBasePath) {
            this.modelBasePath = modelBasePath;
            return this;
        }

        public Builder uploadBaseUrl(String uploadBaseUrl) {
            this.uploadBaseUrl = uploadBaseUrl;
            return this;
        }

        public ModelRepositoryManager build() {
            ModelRepositoryManager modelRepositoryManager = new ModelRepositoryManager();
            modelRepositoryManager.setGroupId(this.groupId);
            modelRepositoryManager.setArtifactId(this.artifactId);
            modelRepositoryManager.setVersion(this.version);
            modelRepositoryManager.setModelBasePath(this.modelBasePath);
            modelRepositoryManager.setModelBaseUrl(this.modelBaseUrl);
            modelRepositoryManager.setUploadBaseUrl(this.uploadBaseUrl);
            return modelRepositoryManager;
        }
    }
}

