/*
 * Decompiled with CFR 0.152.
 */
package com.quasiris.qsf.commons.ai.embedding;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.quasiris.qsf.commons.ai.dto.Document;
import com.quasiris.qsf.commons.ai.dto.TextVector;
import com.quasiris.qsf.commons.ai.dto.TextVectorDocument;
import com.quasiris.qsf.commons.ai.embedding.TextEmbeddingEncoder;
import com.quasiris.qsf.commons.exception.NormalizerNotSupportedException;
import com.quasiris.qsf.commons.nlp.SentenceSplitter;
import com.quasiris.qsf.commons.text.normalizer.TextNormalizerService;
import com.quasiris.qsf.commons.util.EmbeddingUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalSentenceEncoder
implements TextEmbeddingEncoder {
    private static final Logger logger = LoggerFactory.getLogger(UniversalSentenceEncoder.class);
    private String baseUrl;
    private Integer timeout;
    private ObjectMapper objectMapper;

    public UniversalSentenceEncoder(String baseUrl, Integer timeout) {
        this.baseUrl = baseUrl;
        this.timeout = timeout;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public List<TextVector> embed(String text, TextNormalizerService normalizer, boolean autosplit) {
        SentenceSplitter textSplitter = new SentenceSplitter();
        List<String> sentences = autosplit ? textSplitter.split(text) : Arrays.asList(text);
        ArrayList<TextVector> textVectors = new ArrayList<TextVector>();
        for (String sentence : sentences) {
            String normalized = normalizer != null ? normalizer.normalize(sentence) : sentence;
            Double[] vector = null;
            if (StringUtils.isNotBlank((CharSequence)normalized)) {
                try {
                    HttpEntity requestEntity = this.buildEntity(normalized);
                    HttpPost request = new HttpPost(this.baseUrl);
                    request.setEntity(requestEntity);
                    request.addHeader("Content-Type", "application/json");
                    RequestConfig.Builder requestConfig = RequestConfig.custom();
                    requestConfig.setConnectTimeout(this.timeout.intValue());
                    requestConfig.setConnectionRequestTimeout(this.timeout.intValue());
                    requestConfig.setSocketTimeout(this.timeout.intValue());
                    request.setConfig(requestConfig.build());
                    try (CloseableHttpClient httpClient = HttpClients.createDefault();
                         CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                        List outputs;
                        String jsonResult;
                        Map responseBody;
                        HttpEntity entity = response.getEntity();
                        if (entity != null && response.getStatusLine().getStatusCode() == 200 && (responseBody = (Map)this.objectMapper.readValue(jsonResult = EntityUtils.toString((HttpEntity)entity), Map.class)).containsKey("outputs") && (outputs = (List)responseBody.get("outputs")).size() == 1) {
                            List firstVector = (List)outputs.get(0);
                            vector = (Double[])firstVector.stream().toArray(Double[]::new);
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Something gone wrong in GET document for UniversalSentenceEncoder!", (Throwable)e);
                    }
                }
                catch (JsonProcessingException e) {
                    logger.warn(e.getMessage());
                }
            }
            if (EmbeddingUtil.isZeroVector(vector).booleanValue()) {
                vector = null;
            }
            textVectors.add(new TextVector(sentence, null, vector));
        }
        return textVectors;
    }

    @Override
    public TextVectorDocument embed(Document<String> doc, TextNormalizerService normalizer, boolean autosplit) throws NormalizerNotSupportedException {
        throw new NotImplementedException("This method supported yet!");
    }

    @Override
    public List<TextVectorDocument> embedBulk(List<Document<String>> docs, TextNormalizerService normalizer, boolean autosplit) throws NormalizerNotSupportedException {
        throw new NotImplementedException("This method supported yet!");
    }

    private HttpEntity buildEntity(String text) throws JsonProcessingException {
        HashMap body = new HashMap();
        HashMap<String, List<String>> inputMap = new HashMap<String, List<String>>();
        inputMap.put("text", Arrays.asList(text));
        body.put("inputs", inputMap);
        String payload = this.objectMapper.writeValueAsString(body);
        return new StringEntity(payload, "UTF-8");
    }
}

