/*
 * Decompiled with CFR 0.152.
 */
package com.quasiris.qsf.commons.text;

import java.util.regex.Pattern;

public class TextUtils {
    public static Pattern NUMBER_PATTERN = Pattern.compile("[0-9]");

    public static String replaceGermanUmlaut(String input) {
        String output = input.replaceAll("\u00fc", "ue").replaceAll("\u00f6", "oe").replaceAll("\u00e4", "ae").replaceAll("\u00df", "ss");
        output = output.replaceAll("\u00dc(?=[a-z\u00e4\u00f6\u00fc\u00df ])", "Ue").replaceAll("\u00d6(?=[a-z\u00e4\u00f6\u00fc\u00df ])", "Oe").replaceAll("\u00c4(?=[a-z\u00e4\u00f6\u00fc\u00df ])", "Ae");
        output = output.replaceAll("\u00dc", "UE").replaceAll("\u00d6", "OE").replaceAll("\u00c4", "AE");
        return output;
    }

    public static boolean isGermanPostalCode(String token) {
        return token.matches("\\d{5}");
    }

    public static boolean containsNumber(String value) {
        return NUMBER_PATTERN.matcher(value).find();
    }

    public static boolean containsLetter(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Character.isLetter(c)) continue;
            return true;
        }
        return false;
    }
}

