/*
 * Decompiled with CFR 0.152.
 */
package com.quasiris.qsf.commons.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Node<T> {
    private T data = null;
    private List<Node<T>> children = new ArrayList<Node<T>>();
    private Set<Node> parents = new HashSet<Node>();

    public Node() {
    }

    public Node(T data) {
        this.data = data;
    }

    public void addChild(Node child) {
        child.addParent(this);
        this.children.add(child);
    }

    public void addChild(T data) {
        Node<T> newChild = new Node<T>(data);
        this.addChild(newChild);
    }

    public void addChildren(List<Node<T>> children) {
        for (Node<T> t : children) {
            t.addParent(this);
        }
        this.children.addAll(children);
    }

    public void addParent(Node parent) {
        this.parents.add(parent);
    }

    public List<Node<T>> getChildren() {
        return this.children;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void traverse(Node<T> node) {
        if (node != null) {
            System.out.println(node.getData());
            for (Node<T> child : node.getChildren()) {
                child.traverse(child);
            }
        }
    }

    public String toString() {
        return "Node{data=" + this.data + ", children=" + this.children + '}';
    }
}

