/*
 * Decompiled with CFR 0.152.
 */
package com.quasiris.qsf.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class IOUtils {
    public static void copyInputStreamToFile(InputStream inputStream, File targetFile) throws IOException {
        Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static String getAbsoluteFile(String directory, String fileName) {
        if (fileName.toLowerCase().startsWith("http")) {
            return fileName;
        }
        if (fileName.toLowerCase().startsWith("c:\\")) {
            return fileName;
        }
        if (fileName.startsWith("/")) {
            return fileName;
        }
        if (fileName.startsWith("./")) {
            return fileName;
        }
        return directory + "/" + fileName;
    }

    public static File getAbsoluteFileAsFile(String directory, String fileName) {
        return new File(IOUtils.getAbsoluteFile(directory, fileName));
    }

    public static String getDirectoryForFile(String file) {
        File f = new File(file);
        File currentPath = new File(f.getParent());
        return currentPath.getName();
    }

    public static List<String> getFiles(String path) {
        ArrayList<String> fileList = new ArrayList<String>();
        File root = new File(path);
        if (path.contains("*")) {
            WildcardFileFilter fileFilter = new WildcardFileFilter(root.getName());
            WildcardFileFilter dirFilter = new WildcardFileFilter("*");
            Collection files = FileUtils.listFiles((File)root.getParentFile(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            for (File file : files) {
                fileList.add(file.getAbsolutePath());
            }
            return fileList;
        }
        if (root.isFile()) {
            fileList.add(path);
            return fileList;
        }
        if (root.isDirectory()) {
            try {
                return IOUtils.getAllFiles(root.getAbsolutePath()).stream().map(p -> p.toFile().getAbsolutePath()).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("The file or path does not exists: " + path);
    }

    public static InputStream getInputStream(File inputFile) throws IOException {
        return IOUtils.getInputStream(inputFile.getAbsolutePath());
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        return IOUtils.inputStreamToString(inputStream, StandardCharsets.UTF_8.name());
    }

    public static String inputStreamToString(InputStream inputStream, String charset) throws IOException {
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        return textBuilder.toString();
    }

    public static InputStream getInputStream(String inputFileName) throws IOException {
        FileInputStream inputStream = new FileInputStream(inputFileName);
        if (inputFileName.endsWith(".gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static String getString(String location) throws IOException {
        return FileUtils.readFileToString((File)new File(location));
    }

    public static OutputStream getOutputStream(File outputFile) throws IOException {
        return IOUtils.getOutputStream(outputFile.getAbsolutePath());
    }

    public static OutputStream getOutputStream(String outputFileName) throws IOException {
        if ("stdout".equals(outputFileName)) {
            return System.out;
        }
        if ("stderr".equals(outputFileName)) {
            return System.err;
        }
        if (outputFileName.endsWith(".gz")) {
            FileOutputStream out = new FileOutputStream(outputFileName);
            return new GZIPOutputStream(out);
        }
        return new FileOutputStream(outputFileName);
    }

    public static void appendToOutputStream(OutputStream out, String value) throws IOException {
        out.write(value.getBytes("UTF-8"));
    }

    public static void unzip(String zipFile) throws IOException {
        int BUFFER = 2048;
        File file = new File(zipFile);
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(file.getParentFile(), currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (!entry.isDirectory()) {
                int currentByte;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            if (!currentEntry.endsWith(".zip")) continue;
            IOUtils.unzip(destFile.getAbsolutePath());
        }
    }

    public static void zip(String dir, String rootDirName, String zipFile) throws IOException {
        File directory = new File(dir);
        if (rootDirName == null) {
            rootDirName = directory.getName();
        }
        List fileList = IOUtils.getAllFiles(dir).stream().map(p -> p.toFile().getAbsolutePath()).collect(Collectors.toList());
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (String filePath : fileList) {
                int length;
                String name = rootDirName + "/" + filePath.substring(directory.getAbsolutePath().length() + 1, filePath.length());
                ZipEntry zipEntry = new ZipEntry(name);
                zos.putNextEntry(zipEntry);
                FileInputStream fis = new FileInputStream(filePath);
                byte[] buffer = new byte[1024];
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
            }
        }
    }

    public static void zip(String dir, String zipFile) throws IOException {
        IOUtils.zip(dir, null, zipFile);
    }

    public static List<Path> getAllFiles(String directory) throws IOException {
        try (Stream<Path> paths = Files.walk(Paths.get(directory, new String[0]), new FileVisitOption[0]);){
            List<Path> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            return list;
        }
    }

    public static String ensureEndingSlash(String value) {
        if (value == null) {
            return null;
        }
        if (value.endsWith("/")) {
            return value;
        }
        return value + "/";
    }

    public static boolean createDirectoryIfNotExists(File directory) {
        if (!directory.exists()) {
            return directory.mkdirs();
        }
        return false;
    }

    public static boolean createDirectoryIfNotExists(String directory) {
        return IOUtils.createDirectoryIfNotExists(new File(directory));
    }
}

