/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.qubole.quark.plugins.jdbc.JdbcDB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.apache.calcite.sql.SqlDialect;

public class GenericDb
extends JdbcDB {
    private Map<String, Object> properties;
    private String catalogSql = null;
    private String defaultSchema = null;
    private String productName = null;
    private boolean caseSensitive = false;

    public GenericDb(Map<String, Object> properties) {
        super(properties);
        this.properties = properties;
        this.defaultSchema = (String)properties.get("defaultSchema");
        this.catalogSql = (String)properties.get("catalogSql");
        this.productName = (String)properties.get("productName");
        this.caseSensitive = properties.get("isCaseSensitive").toString().equalsIgnoreCase("true");
    }

    @Override
    public Connection getConnection() throws ClassNotFoundException, SQLException {
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    @Override
    protected String getCatalogSql() {
        return this.catalogSql;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public String getProductName() {
        return this.productName;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public SqlDialect getSqlDialect() {
        SqlDialect sqlDialect = SqlDialect.getProduct((String)((String)this.properties.get("type")), null).getDialect();
        return sqlDialect;
    }
}

