/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.google.common.collect.ImmutableMap;
import com.qubole.quark.plugins.jdbc.JdbcDB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.sql.SqlDialect;

public class H2Db
extends JdbcDB {
    private final String catalogSql = "SELECT TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, TYPE_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA != 'INFORMATION_SCHEMA' ORDER BY TABLE_SCHEMA, TABLE_NAME, ORDINAL_POSITION";
    private final String defaultSchema = "PUBLIC";
    private final String productName = "H2";
    private static final ImmutableMap<String, String> DATA_TYPES = new ImmutableMap.Builder().put((Object)"integer", (Object)"integer").put((Object)"character varying", (Object)"character varying").put((Object)"-6", (Object)"smallint").put((Object)"-5", (Object)"integer").put((Object)"3", (Object)"double").put((Object)"4", (Object)"integer").put((Object)"5", (Object)"smallint").put((Object)"8", (Object)"double").put((Object)"12", (Object)"character varying").put((Object)"93", (Object)"timestamp").put((Object)"16", (Object)"boolean").put((Object)"1", (Object)"character").put((Object)"91", (Object)"date").build();

    public H2Db(Map<String, Object> properties) {
        super(properties);
    }

    @Override
    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        Properties props = new Properties();
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        return DriverManager.getConnection(this.url, props);
    }

    @Override
    public String getCatalogSql() {
        return "SELECT TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, TYPE_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA != 'INFORMATION_SCHEMA' ORDER BY TABLE_SCHEMA, TABLE_NAME, ORDINAL_POSITION";
    }

    public String getDefaultSchema() {
        return "PUBLIC";
    }

    public String getProductName() {
        return "H2";
    }

    public SqlDialect getSqlDialect() {
        SqlDialect h2Dialect = SqlDialect.getProduct((String)"H2", null).getDialect();
        return h2Dialect;
    }
}

