/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.google.common.collect.ImmutableMap;
import com.qubole.quark.QuarkException;
import com.qubole.quark.plugins.Executor;
import com.qubole.quark.plugins.jdbc.JdbcSchema;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.calcite.runtime.ResultSetEnumerable;
import org.apache.calcite.schema.Schema;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcDB
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDB.class);
    protected final String url;
    protected final String user;
    protected final String password;

    public abstract Connection getConnection() throws ClassNotFoundException, SQLException;

    protected abstract String getCatalogSql();

    JdbcDB(Map<String, Object> properties) {
        this.validate(properties);
        this.url = (String)properties.get("url");
        this.user = (String)properties.get("username");
        this.password = (String)properties.get("password");
    }

    private void validate(Map<String, Object> properties) {
        Validate.notNull((Object)properties.get("url"), (String)"Field \"url\" specifying JDBC endpoint needs to be defined for JDBC Data Source in JSON");
        Validate.notNull((Object)properties.get("username"), (String)"Field \"username\" specifying username needs to be defined for JDBC Data Source in JSON");
        Validate.notNull((Object)properties.get("password"), (String)"Field \"password\" specifying password to be defined for JDBC Data Source in JSON");
    }

    public ImmutableMap<String, Schema> getSchemas() throws QuarkException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this.getCatalogSql());
            ImmutableMap<String, Schema> schemaMap = this.getSchemaFromResultSet(rs, this.getTypes(conn));
            rs.close();
            ImmutableMap<String, Schema> immutableMap = schemaMap;
            return immutableMap;
        }
        catch (ClassNotFoundException | SQLException s) {
            throw new QuarkException((Throwable)s);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Exception thrown while closing connection to " + this.url + " " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected ImmutableMap<String, Integer> getTypes(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet rs = databaseMetaData.getTypeInfo();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        while (rs.next()) {
            LOG.debug("Registering data type '" + rs.getString("TYPE_NAME") + "'");
            builder.put((Object)rs.getString("TYPE_NAME").toUpperCase(), (Object)rs.getInt("DATA_TYPE"));
        }
        return builder.build();
    }

    private ImmutableMap<String, Schema> getSchemaFromResultSet(ResultSet rs, ImmutableMap<String, Integer> dataTypes) throws SQLException {
        if (rs == null || !rs.next()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder schemaBuilder = new ImmutableMap.Builder();
        while (!rs.isAfterLast()) {
            String currentSchema;
            String schemaKey = currentSchema = rs.getString(1);
            if (!this.isCaseSensitive()) {
                schemaKey = currentSchema.toUpperCase();
            }
            schemaBuilder.put((Object)schemaKey, (Object)new JdbcSchema(currentSchema, rs, this.isCaseSensitive(), dataTypes));
        }
        return schemaBuilder.build();
    }

    @Override
    public Iterator<Object> executeQuery(String sql) throws Exception {
        this.cleanup();
        return this.execute(this.getConnection(), sql);
    }

    public Iterator<Object> execute(final Connection conn, String sql) throws Exception {
        return ResultSetEnumerable.of((DataSource)new DataSource(){

            @Override
            public Connection getConnection() throws SQLException {
                return conn;
            }

            @Override
            public Connection getConnection(String s, String s1) throws SQLException {
                return conn;
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                return null;
            }

            @Override
            public void setLogWriter(PrintWriter printWriter) throws SQLException {
            }

            @Override
            public void setLoginTimeout(int i) throws SQLException {
            }

            @Override
            public int getLoginTimeout() throws SQLException {
                return 100;
            }

            @Override
            public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
                return null;
            }

            @Override
            public <T> T unwrap(Class<T> aClass) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> aClass) throws SQLException {
                return false;
            }
        }, (String)sql).iterator();
    }

    @Override
    public void cleanup() throws SQLException {
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

