/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.google.common.collect.ImmutableMap;
import com.qubole.quark.QuarkException;
import com.qubole.quark.plugin.DataSource;
import com.qubole.quark.plugin.DataSourceFactory;
import com.qubole.quark.plugins.jdbc.EMRDb;
import com.qubole.quark.plugins.jdbc.GenericDb;
import com.qubole.quark.plugins.jdbc.H2Db;
import com.qubole.quark.plugins.jdbc.JdbcDB;
import com.qubole.quark.plugins.jdbc.MysqlDb;
import com.qubole.quark.plugins.jdbc.OracleDb;
import com.qubole.quark.plugins.jdbc.RedShiftDb;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class JdbcFactory
implements DataSourceFactory {
    private static final Map<String, Class<? extends JdbcDB>> DB_PLUGINS = new ImmutableMap.Builder().put((Object)"HIVE", EMRDb.class).put((Object)"REDSHIFT", RedShiftDb.class).put((Object)"H2", H2Db.class).put((Object)"MYSQL", MysqlDb.class).put((Object)"ORACLE", OracleDb.class).put((Object)"GENERIC", GenericDb.class).build();

    public DataSource create(Map<String, Object> properties) throws QuarkException {
        this.validate(properties);
        String type = (String)properties.get("type");
        Class<? extends JdbcDB> dbClass = DB_PLUGINS.get(type.toUpperCase());
        Validate.notNull(dbClass, (String)("Invalid DataSource type: " + type + " Please specify one of these: " + Arrays.toString(DB_PLUGINS.keySet().toArray())));
        return this.getDataSource(properties, dbClass);
    }

    private DataSource getDataSource(Map<String, Object> properties, Class dbClass) throws QuarkException {
        try {
            return (DataSource)dbClass.getConstructor(Map.class).newInstance(properties);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new QuarkException(new Throwable("Invoking invalid constructor on class specified for type " + properties.get("type") + ": " + dbClass.getCanonicalName()));
        }
        catch (InvocationTargetException e) {
            throw new QuarkException(e.getTargetException());
        }
    }

    private void validate(Map<String, Object> properties) {
        Validate.notNull((Object)properties.get("type"), (String)"Field \"type\" specifying type of DataSource endpoint needs to be defined for JDBC Data Source in JSON");
    }
}

