/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.qubole.quark.planner.QuarkColumn;
import com.qubole.quark.planner.QuarkSchema;
import com.qubole.quark.planner.QuarkTable;
import com.qubole.quark.sql.QueryContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSchema
extends QuarkSchema {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSchema.class);
    private final ImmutableMap<String, Table> tableMap;

    public JdbcSchema(String name, ResultSet resultSet, boolean isCaseSensitive, ImmutableMap<String, Integer> dataTypes) throws SQLException {
        super(isCaseSensitive ? name : name.toUpperCase());
        ImmutableMap.Builder tableBuilder = new ImmutableMap.Builder();
        while (!resultSet.isAfterLast() && resultSet.getString(1).equals(name)) {
            ImmutableList.Builder columnBuilder = new ImmutableList.Builder();
            String currentTable = resultSet.getString(2);
            while (resultSet.getString(2).equals(currentTable)) {
                String columnName = resultSet.getString(3);
                if (!isCaseSensitive) {
                    columnName = columnName.toUpperCase();
                }
                Integer dataType = null;
                for (String key : dataTypes.keySet()) {
                    if (!resultSet.getString(4).toUpperCase().matches(key)) continue;
                    dataType = (Integer)dataTypes.get((Object)key);
                    break;
                }
                if (dataType == null) {
                    throw new SQLException("DataType `" + resultSet.getString(4) + "` is not supported");
                }
                columnBuilder.add((Object)new QuarkColumn(columnName, dataType.intValue()));
                LOG.debug("Adding column:  " + resultSet.getString(1) + " : " + resultSet.getString(2) + " : " + resultSet.getString(3) + " : " + resultSet.getString(4));
                if (resultSet.next()) continue;
                break;
            }
            if (!isCaseSensitive) {
                currentTable = currentTable.toUpperCase();
            }
            tableBuilder.put((Object)currentTable, (Object)new QuarkTable((QuarkSchema)this, currentTable, (List)columnBuilder.build()));
        }
        this.tableMap = tableBuilder.build();
    }

    public void initialize(QueryContext queryContext, SchemaPlus schemaPlus) {
        this.schemaPlus = schemaPlus;
        for (Map.Entry entry : this.tableMap.entrySet()) {
            this.schemaPlus.add((String)entry.getKey(), (Table)entry.getValue());
        }
    }

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }
}

