/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.google.common.collect.ImmutableMap;
import com.qubole.quark.plugins.jdbc.JdbcDB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.calcite.sql.SqlDialect;

public class MysqlDb
extends JdbcDB {
    private final String catalogSql = "select table_schema, table_name, column_name, data_type from information_schema.columns order by table_schema, table_name, ordinal_position;";
    public static final ImmutableMap<String, String> DATATYPES = new ImmutableMap.Builder().put((Object)"int\\([0-9]+\\)", (Object)"int").put((Object)"tinyint\\([0-9]+\\)", (Object)"int").put((Object)"smallint\\([0-9]+\\)", (Object)"smallint").put((Object)"mediumint\\([0-9]+\\)", (Object)"int").put((Object)"bigint\\([0-9]+\\)", (Object)"bigint").put((Object)"bigint\\([0-9]+\\)( unsigned)*", (Object)"bigint").put((Object)"float\\([0-9]+,[0-9]+\\)?", (Object)"float").put((Object)"double\\([0-9]+,[0-9]+\\)?", (Object)"double").put((Object)"decimal\\([0-9]+,[0-9]+\\)", (Object)"double").put((Object)"datetime", (Object)"timestamp").put((Object)"char\\([0-9]+\\)", (Object)"char").put((Object)"varchar\\([0-9]+\\)", (Object)"character varying").put((Object)"text", (Object)"string").put((Object)"tinytext", (Object)"string").put((Object)"mediumtext", (Object)"string").put((Object)"longtext", (Object)"string").build();
    private String defaultSchema = null;
    private final String productName = "MYSQL";

    public MysqlDb(Map<String, Object> properties) {
        super(properties);
    }

    @Override
    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    @Override
    protected String getCatalogSql() {
        return "select table_schema, table_name, column_name, data_type from information_schema.columns order by table_schema, table_name, ordinal_position;";
    }

    public String getDefaultSchema() {
        if (this.defaultSchema == null) {
            try {
                ResultSet rs = this.getConnection().createStatement().executeQuery("SELECT DATABASE()");
                rs.next();
                this.defaultSchema = rs.getString(1);
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new RuntimeException("Couldnot fetch DefaultSchema for mysqlError:" + e.getMessage(), e);
            }
        }
        return this.defaultSchema;
    }

    public String getProductName() {
        return "MYSQL";
    }

    public SqlDialect getSqlDialect() {
        SqlDialect sqlDialect = SqlDialect.getProduct((String)"MySQL", null).getDialect();
        return sqlDialect;
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }
}

