/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.google.common.collect.ImmutableMap;
import com.qubole.quark.plugins.jdbc.JdbcDB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.apache.calcite.sql.SqlDialect;

public class OracleDb
extends JdbcDB {
    private final String defaultSchema;
    private final String productName = "ORACLE";
    private final String catalogSql;
    private static final ImmutableMap<String, String> DATATYPES = new ImmutableMap.Builder().put((Object)"NCHAR", (Object)"char").put((Object)"VARCHAR2", (Object)"character varying").put((Object)"NVARCHAR2", (Object)"character varying").put((Object)"NUMBER", (Object)"double").put((Object)"RAW", (Object)"long").put((Object)"LONG RAW", (Object)"long").put((Object)"BINARY_FLOAT", (Object)"float").put((Object)"BINARY_DOUBLE", (Object)"double").put((Object)"BLOB", (Object)"long").put((Object)"CLOB", (Object)"long").put((Object)"NCLOB", (Object)"long").put((Object)"BFILE", (Object)"long").put((Object)"TIMESTAMP\\([0-9]+\\)", (Object)"timestamp").put((Object)"TIMESTAMP\\([0-9]+\\) WITH TIME ZONE", (Object)"timestamp").put((Object)"TIMESTAMP\\([0-9]+\\) WITH LOCAL TIME ZONE", (Object)"timestamp").put((Object)"DATE", (Object)"date").put((Object)"FLOAT", (Object)"float").put((Object)"CHAR", (Object)"char").put((Object)"LONG", (Object)"long").build();

    public OracleDb(Map<String, Object> properties) {
        super(properties);
        this.defaultSchema = this.user.toUpperCase();
        this.productName = "ORACLE";
        this.catalogSql = "select owner, table_name, column_name, data_type from all_tab_cols where owner='" + this.user.toUpperCase() + "' order by table_name, column_id";
    }

    @Override
    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName("oracle.jdbc.OracleDriver");
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    @Override
    protected String getCatalogSql() {
        return this.catalogSql;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public String getProductName() {
        return "ORACLE";
    }

    public SqlDialect getSqlDialect() {
        SqlDialect sqlDialect = SqlDialect.getProduct((String)"Oracle", null).getDialect();
        return sqlDialect;
    }
}

