/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.jdbc;

import com.google.common.collect.ImmutableMap;
import com.qubole.quark.plugins.jdbc.JdbcDB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.sql.SqlDialect;

public class RedShiftDb
extends JdbcDB {
    private final String catalogSql = "SELECT schemaname, tablename, \"column\", type FROM pg_table_def WHERE schemaname != 'pg_catalog' ORDER BY schemaname, tablename";
    private final String defaultSchema = "PUBLIC";
    private final String productName = "REDSHIFT";
    protected static final ImmutableMap<String, Integer> DATA_TYPES = new ImmutableMap.Builder().put((Object)"STRING", (Object)12).put((Object)"INTEGER", (Object)4).put((Object)"SMALLINT", (Object)5).put((Object)"BIGINT", (Object)-5).put((Object)"TINYINT", (Object)-6).put((Object)"CHARACTER VARYING", (Object)12).put((Object)"CHARACTER", (Object)1).put((Object)Primitive.BYTE.primitiveClass.getSimpleName(), (Object)-6).put((Object)Primitive.CHAR.primitiveClass.getSimpleName(), (Object)-6).put((Object)Primitive.SHORT.primitiveClass.getSimpleName(), (Object)5).put((Object)Primitive.INT.primitiveClass.getSimpleName(), (Object)4).put((Object)Primitive.LONG.primitiveClass.getSimpleName(), (Object)-5).put((Object)Primitive.FLOAT.primitiveClass.getSimpleName(), (Object)6).put((Object)Primitive.DOUBLE.primitiveClass.getSimpleName(), (Object)8).put((Object)"DATE", (Object)91).put((Object)"TIME", (Object)93).put((Object)"CHARACTER VARYING\\([0-9]+\\)", (Object)12).put((Object)"TIMESTAMP WITHOUT TIME ZONE", (Object)93).put((Object)"DOUBLE PRECISION", (Object)8).put((Object)"CHARACTER\\([0-9]+\\)", (Object)1).build();

    public RedShiftDb(Map<String, Object> properties) {
        super(properties);
    }

    @Override
    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Properties props = new Properties();
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        return DriverManager.getConnection(this.url, props);
    }

    @Override
    protected ImmutableMap<String, Integer> getTypes(Connection connection) {
        return DATA_TYPES;
    }

    @Override
    public String getCatalogSql() {
        return "SELECT schemaname, tablename, \"column\", type FROM pg_table_def WHERE schemaname != 'pg_catalog' ORDER BY schemaname, tablename";
    }

    public String getDefaultSchema() {
        return "PUBLIC";
    }

    public String getProductName() {
        return "REDSHIFT";
    }

    public SqlDialect getSqlDialect() {
        SqlDialect redshiftDialect = SqlDialect.getProduct((String)"REDSHIFT", null).getDialect();
        return redshiftDialect;
    }
}

