/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.qubole;

import com.google.common.collect.ImmutableMap;
import com.qubole.qds.sdk.java.api.InvokableBuilder;
import com.qubole.qds.sdk.java.client.QdsClient;
import com.qubole.qds.sdk.java.client.ResultLatch;
import com.qubole.qds.sdk.java.entities.CommandResponse;
import com.qubole.qds.sdk.java.entities.DbTap;
import com.qubole.qds.sdk.java.entities.ResultValue;
import com.qubole.qds.sdk.java.entities.SchemaList;
import com.qubole.qds.sdk.java.entities.SchemaListDescribed;
import com.qubole.qds.sdk.java.entities.SchemaOrdinal;
import com.qubole.quark.plugins.qubole.QuboleDB;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.sql.SqlDialect;
import org.apache.commons.lang.Validate;

public class DbTapDb
extends QuboleDB {
    protected int dbTapid;
    private String productName = null;
    private String defaultSchema = null;
    private static final ImmutableMap<String, Integer> REDSHIFT_TYPES = new ImmutableMap.Builder().put((Object)"character varying\\([0-9]+\\)", (Object)12).put((Object)"timestamp without time zone", (Object)93).put((Object)"double precision", (Object)8).put((Object)"character\\([0-9]+\\)", (Object)6).put((Object)"real", (Object)6).build();

    public DbTapDb(Map<String, Object> properties) {
        super(properties);
        Validate.notNull((Object)properties.get("dbtapid"), (String)"Field \"dbtapid\" specifying Qubole's endpoint needs to be defined for Qubole Data Source of type DBTAP in JSON");
        this.dbTapid = Integer.parseInt(properties.get("dbtapid").toString());
    }

    @Override
    protected Map<String, List<SchemaOrdinal>> getSchemaListDescribed() throws ExecutionException, InterruptedException {
        SchemaListDescribed schemaListDescribed = (SchemaListDescribed)this.getQdsClient().dbTaps().getSchemaListDescribed(this.dbTapid).invoke().get();
        Map<String, List<SchemaOrdinal>> schemas = schemaListDescribed.getSchemas();
        int per_page = schemaListDescribed.getPaging_info().getPer_page();
        int current_page = 2;
        while (schemaListDescribed.getPaging_info().getNext_page() != null) {
            schemaListDescribed = (SchemaListDescribed)((InvokableBuilder)this.getQdsClient().dbTaps().getSchemaListDescribed(this.dbTapid).forPage(current_page++, per_page)).invoke().get();
            schemas = this.mergeSchemas(schemas, schemaListDescribed.getSchemas());
        }
        return schemas;
    }

    @Override
    protected ImmutableMap<String, Integer> getDataTypes() {
        String type = this.getProductName();
        switch (type.toUpperCase()) {
            case "REDSHIFT": {
                return REDSHIFT_TYPES;
            }
        }
        return ImmutableMap.of();
    }

    public String getDefaultSchema() {
        try {
            SchemaList schemaList = (SchemaList)this.getQdsClient().dbTaps().getSchemaNames(this.dbTapid).invoke().get();
            this.defaultSchema = schemaList.getDefault_schema().toUpperCase();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Couldnot fetch defaultSchema for Qubole DataSource id: " + this.dbTapid + " Error:" + e.getMessage(), e);
        }
        return this.defaultSchema;
    }

    public String getProductName() {
        if (this.productName == null) {
            try {
                DbTap dbTap = (DbTap)this.getQdsClient().dbTaps().view(this.dbTapid).invoke().get();
                this.productName = dbTap.getDb_type().toUpperCase();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Couldnot fetch productName for Qubole DataSource id: " + this.dbTapid + " Error:" + e.getMessage(), e);
            }
        }
        return this.productName;
    }

    public SqlDialect getSqlDialect() {
        SqlDialect dialect;
        String type = this.getProductName();
        switch (type.toUpperCase()) {
            case "HIVE": {
                dialect = SqlDialect.getProduct((String)"Hive", null).getDialect();
                break;
            }
            case "REDSHIFT": {
                dialect = SqlDialect.getProduct((String)"REDSHIFT", null).getDialect();
                break;
            }
            case "SQLSERVER": 
            case "MYSQL": {
                dialect = SqlDialect.getProduct((String)"MySQL", null).getDialect();
                break;
            }
            case "POSTGRESQL": {
                dialect = SqlDialect.getProduct((String)"PostgreSQL", null).getDialect();
                break;
            }
            case "VERTICA": {
                dialect = SqlDialect.getProduct((String)"Vertica", null).getDialect();
                break;
            }
            default: {
                dialect = SqlDialect.getProduct((String)"UNKNOWN", null).getDialect();
            }
        }
        return dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Object> executeQuery(String sql) throws Exception {
        ResultValue resultValue;
        try (QdsClient client = this.getQdsClient();){
            CommandResponse commandResponse = (CommandResponse)client.command().dbTapQuery(sql, this.dbTapid).invoke().get();
            ResultLatch resultLatch = new ResultLatch(client, commandResponse.getId());
            resultValue = resultLatch.awaitResult();
        }
        return this.convertToIterator(resultValue);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.getProductName().toUpperCase().equals("MYSQL");
    }
}

