/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.qubole;

import com.google.common.collect.ImmutableMap;
import com.qubole.qds.sdk.java.api.InvokableBuilder;
import com.qubole.qds.sdk.java.client.QdsClient;
import com.qubole.qds.sdk.java.client.ResultLatch;
import com.qubole.qds.sdk.java.entities.CommandResponse;
import com.qubole.qds.sdk.java.entities.ResultValue;
import com.qubole.qds.sdk.java.entities.SchemaListDescribed;
import com.qubole.qds.sdk.java.entities.SchemaOrdinal;
import com.qubole.quark.plugins.qubole.QuboleDB;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.sql.SqlDialect;

public class HiveDb
extends QuboleDB {
    private final String defaultSchema = "DEFAULT";
    private final String productName = "HIVE";
    private final boolean isCaseSensitive = false;
    private static final ImmutableMap<String, Integer> HIVE_DATA_TYPES = new ImmutableMap.Builder().put((Object)"character varying\\([0-9]+\\)", (Object)12).put((Object)"varchar\\([0-9]+\\)", (Object)12).put((Object)"char\\([0-9]+\\)", (Object)1).put((Object)"character\\([0-9]+\\)", (Object)1).put((Object)"decimal\\([0-9]+,[0-9]+\\)", (Object)3).put((Object)"timestamp", (Object)93).build();

    public HiveDb(Map<String, Object> properties) {
        super(properties);
    }

    @Override
    protected Map<String, List<SchemaOrdinal>> getSchemaListDescribed() throws ExecutionException, InterruptedException {
        SchemaListDescribed schemaListDescribed = (SchemaListDescribed)this.getQdsClient().hiveMetadata().getSchemaListDescribed().invoke().get();
        Map<String, List<SchemaOrdinal>> schemas = schemaListDescribed.getSchemas();
        int per_page = schemaListDescribed.getPaging_info().getPer_page();
        int current_page = 2;
        while (schemaListDescribed.getPaging_info().getNext_page() != null) {
            schemaListDescribed = (SchemaListDescribed)((InvokableBuilder)this.getQdsClient().hiveMetadata().getSchemaListDescribed().forPage(current_page, per_page)).invoke().get();
            schemas = this.mergeSchemas(schemas, schemaListDescribed.getSchemas());
        }
        return schemas;
    }

    @Override
    protected ImmutableMap<String, Integer> getDataTypes() {
        return HIVE_DATA_TYPES;
    }

    public String getDefaultSchema() {
        return "DEFAULT";
    }

    public String getProductName() {
        return "HIVE";
    }

    public SqlDialect getSqlDialect() {
        SqlDialect hiveDialect = SqlDialect.getProduct((String)"Hive", null).getDialect();
        return hiveDialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Object> executeQuery(String sql) throws Exception {
        ResultValue resultValue;
        try (QdsClient client = this.getQdsClient();){
            CommandResponse commandResponse = (CommandResponse)client.command().hive().query(sql).invoke().get();
            ResultLatch resultLatch = new ResultLatch(client, commandResponse.getId());
            resultValue = resultLatch.awaitResult();
        }
        return this.convertToIterator(resultValue);
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }
}

